/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.awt.Stroke;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Line;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class LinePlot
extends ScatterPlot {
    private boolean drawDot = false;
    private Line line;

    public LinePlot(double[][] data) {
        this(data, Line.Style.SOLID);
    }

    public LinePlot(double[][] data, Line.Style style) {
        super(data, '.');
        this.line = new Line(style, data);
    }

    @Override
    public LinePlot setColor(Color color) {
        super.setColor(color);
        this.line.setColor(color);
        return this;
    }

    @Override
    public Color getColor() {
        return this.line.getColor();
    }

    public Stroke getStroke() {
        return this.line.getStroke();
    }

    public LinePlot setStroke(Stroke stroke) {
        this.line.setStroke(stroke);
        return this;
    }

    @Override
    public LinePlot setLegend(char legend) {
        super.setLegend(legend);
        this.drawDot = true;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        this.line.paint(g);
        if (this.drawDot) {
            super.paint(g);
        }
    }

    public static PlotCanvas plot(double[] y) {
        return LinePlot.plot(null, y);
    }

    public static PlotCanvas plot(String id, double[] y) {
        double[] lowerBound = new double[]{0.0, Math.min((double[])y)};
        double[] upperBound = new double[]{y.length, Math.max((double[])y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.base.extendBound(1);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[] y, Line.Style style) {
        return LinePlot.plot(null, y, style);
    }

    public static PlotCanvas plot(String id, double[] y, Line.Style style) {
        double[] lowerBound = new double[]{0.0, Math.min((double[])y)};
        double[] upperBound = new double[]{y.length, Math.max((double[])y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.base.extendBound(1);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[] y, Line.Style style, Color color) {
        return LinePlot.plot(null, y, style, color);
    }

    public static PlotCanvas plot(String id, double[] y, Line.Style style, Color color) {
        double[] lowerBound = new double[]{0.0, Math.min((double[])y)};
        double[] upperBound = new double[]{y.length, Math.max((double[])y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.base.extendBound(1);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        plot.setColor(color);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, Line.Style style) {
        return LinePlot.plot(null, data, style);
    }

    public static PlotCanvas plot(String id, double[][] data, Line.Style style) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, Line.Style style, Color color) {
        return LinePlot.plot(null, data, style, color);
    }

    public static PlotCanvas plot(String id, double[][] data, Line.Style style, Color color) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        plot.setColor(color);
        canvas.add(plot);
        return canvas;
    }
}

