/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.awt.Font;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Shape;

public class Label
extends Shape {
    String text;
    double[] coord;
    double horizontalReference;
    double verticalReference;
    double rotation = 0.0;
    Font font;

    public Label(String text, double[] coord) {
        this(text, 0.5, 0.5, coord);
    }

    public Label(String text, double rotation, double[] coord) {
        this(text, 0.5, 0.5, rotation, coord);
    }

    public Label(String text, double horizontalReference, double verticalReference, double[] coord) {
        this(text, horizontalReference, verticalReference, 0.0, coord);
    }

    public Label(String text, double horizontalReference, double verticalReference, double rotation, double[] coord) {
        this.text = text;
        this.horizontalReference = horizontalReference;
        this.verticalReference = verticalReference;
        this.rotation = rotation;
        this.coord = coord;
    }

    public Label(double ... coord) {
        this(Label.coordToString(coord), coord);
    }

    public Label setText(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Label setCoordinate(double ... coord) {
        this.coord = coord;
        return this;
    }

    public double[] getCoordinate() {
        return this.coord;
    }

    public Label setRotation(double angle) {
        this.rotation = angle;
        return this;
    }

    public double getRotation() {
        return this.rotation;
    }

    public Label setFont(Font font) {
        this.font = font;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void paint(Graphics g) {
        Font f = g.getFont();
        if (this.font != null) {
            g.setFont(this.font);
        }
        Color c = g.getColor();
        g.setColor(this.getColor());
        g.drawText(this.text, this.horizontalReference, this.verticalReference, this.rotation, this.coord);
        g.setColor(c);
        if (this.font != null) {
            g.setFont(f);
        }
    }

    public static String coordToString(double ... c) {
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < c.length; ++i) {
            builder.append(Math.round((double)c[i], (int)2)).append(",");
        }
        if (c.length > 0) {
            builder.setCharAt(builder.length(), ')');
        } else {
            builder.append(")");
        }
        return builder.toString();
    }
}

