/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import smile.math.Math;
import smile.plot.BarPlot;
import smile.plot.PlotCanvas;

public class Histogram
extends BarPlot {
    private boolean prob;

    public Histogram(int[] data) {
        this(data, true);
    }

    public Histogram(int[] data, boolean prob) {
        this(data, smile.math.Histogram.bins((int)data.length), prob);
    }

    public Histogram(int[] data, int k) {
        this(data, k, true);
    }

    public Histogram(int[] data, int k, boolean prob) {
        super(Histogram.histogram(data, k, prob));
        this.prob = prob;
    }

    public Histogram(int[] data, double[] breaks) {
        this(data, breaks, true);
    }

    public Histogram(int[] data, double[] breaks, boolean prob) {
        super(Histogram.histogram(data, breaks, prob));
        this.prob = prob;
    }

    public Histogram(double[] data) {
        this(data, true);
    }

    public Histogram(double[] data, boolean prob) {
        this(data, smile.math.Histogram.bins((int)data.length), prob);
    }

    public Histogram(double[] data, int k) {
        this(data, k, true);
    }

    public Histogram(double[] data, int k, boolean prob) {
        super(Histogram.histogram(data, k, prob));
        this.prob = prob;
    }

    public Histogram(double[] data, double[] breaks) {
        this(data, breaks, true);
    }

    public Histogram(double[] data, double[] breaks, boolean prob) {
        super(Histogram.histogram(data, breaks, prob));
        this.prob = prob;
    }

    public double[][] getHistogram() {
        return this.data;
    }

    public int getNumBins() {
        return this.data.length;
    }

    @Override
    public String getToolTip(double[] coord) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!(coord[0] < this.rightBottom[i][0]) || !(coord[0] > this.leftBottom[i][0]) || !(coord[1] < this.rightTop[i][1]) || !(coord[1] > this.rightBottom[i][1])) continue;
            double upper = this.rightBottom[i][0];
            double lower = this.leftBottom[i][0];
            int precision = (int)Math.round((double)Math.log10((double)Math.abs((double)(upper - lower))));
            precision = precision > 0 ? 0 : -precision + 1;
            String format = String.format(" in [%%.%df, %%.%df]", precision, precision);
            if (this.prob) {
                return String.format("%.1f%%" + format, 100.0 * this.data[i][1], lower, upper);
            }
            return String.format("%d" + format, (int)this.data[i][1], lower, upper);
        }
        return null;
    }

    private static double[][] histogram(int[] data, int k, boolean prob) {
        double[][] hist = smile.math.Histogram.histogram((int[])data, (int)k);
        k = hist[0].length;
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return freq;
    }

    private static double[][] histogram(double[] data, int k, boolean prob) {
        double[][] hist = smile.math.Histogram.histogram((double[])data, (int)k);
        k = hist[0].length;
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return freq;
    }

    private static double[][] histogram(int[] data, double[] breaks, boolean prob) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] hist = smile.math.Histogram.histogram((int[])data, (double[])breaks);
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return freq;
    }

    private static double[][] histogram(double[] data, double[] breaks, boolean prob) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] hist = smile.math.Histogram.histogram((double[])data, (double[])breaks);
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return freq;
    }

    public static PlotCanvas plot(double[] data) {
        return Histogram.plot((String)null, data);
    }

    public static PlotCanvas plot(String id, double[] data) {
        Histogram histogram = new Histogram(data);
        histogram.setID(id);
        double[] lowerBound = new double[]{Math.min((double[])data), 0.0};
        double[] upperBound = new double[]{Math.max((double[])data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(double[] data, int k) {
        return Histogram.plot(null, data, k);
    }

    public static PlotCanvas plot(String id, double[] data, int k) {
        Histogram histogram = new Histogram(data, k);
        histogram.setID(id);
        double[] lowerBound = new double[]{Math.min((double[])data), 0.0};
        double[] upperBound = new double[]{Math.max((double[])data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(double[] data, double[] breaks) {
        return Histogram.plot(null, data, breaks);
    }

    public static PlotCanvas plot(String id, double[] data, double[] breaks) {
        return Histogram.plot(id, data, breaks, true);
    }

    public static PlotCanvas plot(String id, double[] data, double[] breaks, boolean prob) {
        Histogram histogram = new Histogram(data, breaks, prob);
        histogram.setID(id);
        double[] lowerBound = new double[]{Math.min((double[])data), 0.0};
        double[] upperBound = new double[]{Math.max((double[])data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(int[] data) {
        return Histogram.plot((String)null, data);
    }

    public static PlotCanvas plot(String id, int[] data) {
        Histogram histogram = new Histogram(data);
        histogram.setID(id);
        double[] lowerBound = new double[]{(double)Math.min((int[])data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max((int[])data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(int[] data, int k) {
        return Histogram.plot(null, data, k);
    }

    public static PlotCanvas plot(String id, int[] data, int k) {
        Histogram histogram = new Histogram(data, k);
        histogram.setID(id);
        double[] lowerBound = new double[]{(double)Math.min((int[])data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max((int[])data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }

    public static PlotCanvas plot(int[] data, double[] breaks) {
        return Histogram.plot(null, data, breaks);
    }

    public static PlotCanvas plot(String id, int[] data, double[] breaks) {
        Histogram histogram = new Histogram(data, breaks);
        histogram.setID(id);
        double[] lowerBound = new double[]{(double)Math.min((int[])data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max((int[])data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        canvas.add(histogram);
        return canvas;
    }
}

