/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Palette;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class Hexmap
extends Plot {
    private double[][] z;
    private String[][] labels;
    private double[][][][] hexagon;
    private double min;
    private double max;
    private double width;
    private Color[] palette;

    public Hexmap(double[][] z) {
        this(z, 16);
    }

    public Hexmap(double[][] z, int k) {
        this(z, Palette.jet(k, 1.0f));
    }

    public Hexmap(double[][] z, Color[] palette) {
        this((String[][])null, z, palette);
    }

    public Hexmap(String[][] labels, double[][] z) {
        this(labels, z, 16);
    }

    public Hexmap(String[][] labels, double[][] z, int k) {
        this(labels, z, Palette.jet(k, 1.0f));
    }

    public Hexmap(String[][] labels, double[][] z, Color[] palette) {
        this.labels = labels;
        this.z = z;
        this.palette = palette;
        double s = Math.sqrt((double)0.75);
        this.hexagon = new double[z.length][z[0].length][6][2];
        for (int i = 0; i < z.length; ++i) {
            for (int j = 0; j < z[i].length; ++j) {
                for (int r = 0; r < this.hexagon[i][j].length; ++r) {
                    double a = 1.0471975511965976 * (double)r;
                    this.hexagon[i][j][r][0] = (double)j + Math.sin((double)a) / 2.0;
                    if (i % 2 == 1) {
                        double[] dArray = this.hexagon[i][j][r];
                        dArray[0] = dArray[0] + 0.5;
                    }
                    this.hexagon[i][j][r][1] = (double)(z.length - i) * s + Math.cos((double)a) / 2.0;
                }
            }
        }
        int n = z.length * z[0].length;
        double[] values = new double[n];
        int i = 0;
        double[][] dArray = z;
        int n2 = dArray.length;
        for (int j = 0; j < n2; ++j) {
            double[] zi;
            for (double zij : zi = dArray[j]) {
                if (Double.isNaN(zij)) continue;
                values[i++] = zij;
            }
        }
        if (i > 0) {
            Arrays.sort(values, 0, i);
            this.min = values[(int)Math.round((double)(0.01 * (double)i))];
            this.max = values[(int)Math.round((double)(0.99 * (double)(i - 1)))];
            this.width = (this.max - this.min) / (double)palette.length;
        }
    }

    @Override
    public String getToolTip(double[] coord) {
        if (this.labels == null) {
            return null;
        }
        if (coord[0] < -0.5 || coord[0] > (double)this.z[0].length || coord[1] < 0.36 || coord[1] > (double)this.z.length * 0.87 + 0.5) {
            return null;
        }
        int x = (int)(coord[0] + 0.5);
        int y = (int)((double)this.z.length - (coord[1] - 0.5) / 0.87);
        for (int i = -3; i < 3; ++i) {
            for (int j = -3; j < 3; ++j) {
                int xi = x + i;
                int yj = y + j;
                if (xi < 0 || xi >= this.hexagon[0].length || yj < 0 || yj >= this.hexagon.length || !Math.contains((double[][])this.hexagon[yj][xi], (double[])coord)) continue;
                return this.labels[yj][xi];
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        for (int i = 0; i < this.z.length; ++i) {
            for (int j = 0; j < this.z[i].length; ++j) {
                if (Double.isNaN(this.z[i][j])) {
                    g.setColor(Color.WHITE);
                } else {
                    int k = (int)((this.z[i][j] - this.min) / this.width);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= this.palette.length) {
                        k = this.palette.length - 1;
                    }
                    g.setColor(this.palette[k]);
                }
                g.fillPolygon(this.hexagon[i][j]);
            }
        }
        g.clearClip();
        double height = 0.7 / (double)this.palette.length;
        double[] start = new double[]{1.1, 0.15};
        double[] end = new double[]{1.13, start[1] - height};
        for (int i = 0; i < this.palette.length; ++i) {
            g.setColor(this.palette[i]);
            g.fillRectBaseRatio(start, end);
            start[1] = start[1] + height;
            end[1] = end[1] + height;
        }
        g.setColor(Color.BLACK);
        start[1] = start[1] - height;
        end[1] = 0.15 - height;
        g.drawRectBaseRatio(start, end);
        start[0] = 1.14;
        double log = Math.log10((double)Math.abs((double)this.max));
        int decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(Math.round((double)this.max, (int)decimal)), 0.0, 1.0, start);
        start[1] = 0.15 - height;
        log = Math.log10((double)Math.abs((double)this.min));
        decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(Math.round((double)this.min, (int)decimal)), 0.0, 0.0, start);
        g.setColor(c);
    }

    public static PlotCanvas plot(double[][] data) {
        double[] lowerBound = new double[]{-0.5, 0.36};
        double[] upperBound = new double[]{data[0].length, (double)data.length * 0.87 + 0.5};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Hexmap(data));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, Color[] palette) {
        double[] lowerBound = new double[]{-0.5, 0.36};
        double[] upperBound = new double[]{data[0].length, (double)data.length * 0.87 + 0.5};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Hexmap(data, palette));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(String[][] labels, double[][] data) {
        double[] lowerBound = new double[]{-0.5, 0.36};
        double[] upperBound = new double[]{data[0].length, (double)data.length * 0.87 + 0.5};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Hexmap(labels, data));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(String[][] labels, double[][] data, Color[] palette) {
        double[] lowerBound = new double[]{-0.5, 0.36};
        double[] upperBound = new double[]{data[0].length, (double)data.length * 0.87 + 0.5};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new Hexmap(labels, data, palette));
        canvas.getAxis(0).setFrameVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setFrameVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }
}

