/*
 * Decompiled with CFR 0.152.
 */
package smile.taxonomy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import smile.taxonomy.Taxonomy;

public class Concept {
    Taxonomy taxonomy = null;
    Set<String> synset;
    Concept parent;
    List<Concept> children;

    Concept() {
    }

    public Concept(Concept parent, String ... keywords) {
        if (parent == null) {
            throw new NullPointerException("Parent concept cannot be null.");
        }
        this.parent = parent;
        this.synset = new TreeSet<String>();
        for (String keyword : keywords) {
            this.synset.add(keyword);
        }
        if (parent.children == null) {
            parent.children = new ArrayList<Concept>();
        }
        parent.children.add(this);
        this.taxonomy = parent.taxonomy;
        for (String keyword : keywords) {
            if (!this.taxonomy.concepts.containsKey(keyword)) continue;
            throw new IllegalArgumentException(String.format("Concept %s already exists.", keyword));
        }
        for (String keyword : keywords) {
            this.taxonomy.concepts.put(keyword, this);
        }
    }

    public boolean isLeaf() {
        return this.children == null ? true : this.children.isEmpty();
    }

    public Set<String> getKeywords() {
        return this.synset;
    }

    public void addKeywords(String ... keywords) {
        for (String keyword : keywords) {
            if (!this.taxonomy.concepts.containsKey(keyword)) continue;
            throw new IllegalArgumentException(String.format("Concept %s already exists.", keyword));
        }
        for (String keyword : keywords) {
            this.taxonomy.concepts.put(keyword, this);
        }
        if (this.synset == null) {
            this.synset = new TreeSet<String>();
        }
        for (String keyword : keywords) {
            this.synset.add(keyword);
        }
    }

    public void removeKeyword(String keyword) {
        if (!this.taxonomy.concepts.containsKey(keyword)) {
            throw new IllegalArgumentException(String.format("Concept %s does not exist.", keyword));
        }
        this.taxonomy.concepts.remove(keyword);
        if (this.synset != null) {
            this.synset.remove(keyword);
        }
    }

    public List<Concept> getChildren() {
        return this.children;
    }

    public Concept addChild(String concept) {
        Concept c = new Concept(this, concept);
        return c;
    }

    public void addChild(Concept concept) {
        if (this.taxonomy != concept.taxonomy) {
            throw new IllegalArgumentException("Concepts are not from the same taxonomy.");
        }
        if (this.children == null) {
            this.children = new ArrayList<Concept>();
        }
        this.children.add(concept);
        concept.parent = this;
    }

    public boolean removeChild(Concept concept) {
        if (concept.parent != this) {
            throw new IllegalArgumentException("Concept to remove is not a child");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != concept) continue;
            this.children.remove(i);
            concept.parent = null;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Concept concept) {
        Concept p = concept.parent;
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public List<Concept> getPathFromRoot() {
        LinkedList<Concept> path = new LinkedList<Concept>();
        Concept node = this;
        while (node != null) {
            path.addFirst(node);
            node = node.parent;
        }
        return path;
    }

    public List<Concept> getPathToRoot() {
        LinkedList<Concept> path = new LinkedList<Concept>();
        Concept node = this;
        while (node != null) {
            path.add(node);
            node = node.parent;
        }
        return path;
    }

    public String toString() {
        String displayName = "anonymous";
        if (this.synset != null && !this.synset.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Iterator<String> iter = this.synset.iterator();
            builder.append(iter.next());
            while (iter.hasNext()) {
                builder.append(", ");
                builder.append(iter.next());
            }
            builder.append(']');
            displayName = builder.toString();
        }
        return String.format("Concept %s", displayName);
    }
}

