/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.math.special.Erf;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.ExponentialFamily;
import smile.stat.distribution.Mixture;

public class GaussianDistribution
extends AbstractDistribution
implements ExponentialFamily {
    private static final long serialVersionUID = 2L;
    private static final double LOG2PIE_2 = Math.log(17.079468445347132) / 2.0;
    private static final double LOG2PI_2 = Math.log(Math.PI * 2) / 2.0;
    private static final GaussianDistribution singleton = new GaussianDistribution(0.0, 1.0);
    public final double mu;
    public final double sigma;
    private double variance;
    private double entropy;
    private double pdfConstant;
    private double z1 = Double.NaN;

    public GaussianDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
        this.variance = sigma * sigma;
        this.entropy = Math.log(sigma) + LOG2PIE_2;
        this.pdfConstant = Math.log(sigma) + LOG2PI_2;
    }

    public static GaussianDistribution fit(double[] data) {
        double mu = MathEx.mean(data);
        double sigma = MathEx.sd(data);
        return new GaussianDistribution(mu, sigma);
    }

    public static GaussianDistribution getInstance() {
        return singleton;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double sd() {
        return this.sigma;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Gaussian Distribution(%.4f, %.4f)", this.mu, this.sigma);
    }

    @Override
    public double rand() {
        double z0;
        if (Double.isNaN(this.z1)) {
            double y;
            double x;
            double r;
            while ((r = (x = MathEx.random(-1.0, 1.0)) * x + (y = MathEx.random(-1.0, 1.0)) * y) >= 1.0) {
            }
            double z = Math.sqrt(-2.0 * Math.log(r) / r);
            this.z1 = x * z;
            z0 = y * z;
        } else {
            z0 = this.z1;
            this.z1 = Double.NaN;
        }
        return this.mu + this.sigma * z0;
    }

    public double randInverseCDF() {
        double x;
        double a0 = 2.50662823884;
        double a1 = -18.61500062529;
        double a2 = 41.39119773534;
        double a3 = -25.44106049637;
        double b0 = -8.4735109309;
        double b1 = 23.08336743743;
        double b2 = -21.06224101826;
        double b3 = 3.13082909833;
        double c0 = 0.3374754822726147;
        double c1 = 0.9761690190917186;
        double c2 = 0.1607979714918209;
        double c3 = 0.0276438810333863;
        double c4 = 0.0038405729373609;
        double c5 = 3.951896511919E-4;
        double c6 = 3.21767881768E-5;
        double c7 = 2.888167364E-7;
        double c8 = 3.960315187E-7;
        double u = MathEx.random();
        while (u == 0.0) {
            u = MathEx.random();
        }
        double y = u - 0.5;
        if (Math.abs(y) < 0.42) {
            double r = y * y;
            x = y * (((-25.44106049637 * r + 41.39119773534) * r + -18.61500062529) * r + 2.50662823884) / ((((3.13082909833 * r + -21.06224101826) * r + 23.08336743743) * r + -8.4735109309) * r + 1.0);
        } else {
            double r = u;
            if (y > 0.0) {
                r = 1.0 - u;
            }
            r = Math.log(-Math.log(r));
            x = 0.3374754822726147 + r * (0.9761690190917186 + r * (0.1607979714918209 + r * (0.0276438810333863 + r * (0.0038405729373609 + r * (3.951896511919E-4 + r * (3.21767881768E-5 + r * (2.888167364E-7 + r * 3.960315187E-7)))))));
            if (y < 0.0) {
                x = -x;
            }
        }
        return this.mu + this.sigma * x;
    }

    @Override
    public double p(double x) {
        if (this.sigma == 0.0) {
            if (x == this.mu) {
                return 1.0;
            }
            return 0.0;
        }
        return Math.exp(this.logp(x));
    }

    @Override
    public double logp(double x) {
        if (this.sigma == 0.0) {
            if (x == this.mu) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double d = x - this.mu;
        return -0.5 * d * d / this.variance - this.pdfConstant;
    }

    @Override
    public double cdf(double x) {
        if (this.sigma == 0.0) {
            if (x < this.mu) {
                return 0.0;
            }
            return 1.0;
        }
        return 0.5 * Erf.erfc(-0.7071067811865476 * (x - this.mu) / this.sigma);
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        if (this.sigma == 0.0) {
            if (p < 1.0) {
                return this.mu - 1.0E-10;
            }
            return this.mu;
        }
        return -1.4142135623730951 * this.sigma * Erf.inverfc(2.0 * p) + this.mu;
    }

    @Override
    public Mixture.Component M(double[] x, double[] posteriori) {
        int i;
        double alpha = 0.0;
        double mean = 0.0;
        double sd = 0.0;
        for (i = 0; i < x.length; ++i) {
            alpha += posteriori[i];
            mean += x[i] * posteriori[i];
        }
        mean /= alpha;
        for (i = 0; i < x.length; ++i) {
            double d = x[i] - mean;
            sd += d * d * posteriori[i];
        }
        sd = Math.sqrt(sd / alpha);
        return new Mixture.Component(alpha, new GaussianDistribution(mean, sd));
    }
}

