/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

public interface Sort {
    public static void swap(int[] arr, int i, int j) {
        int a = arr[i];
        arr[i] = arr[j];
        arr[j] = a;
    }

    public static void swap(float[] arr, int i, int j) {
        float a = arr[i];
        arr[i] = arr[j];
        arr[j] = a;
    }

    public static void swap(double[] arr, int i, int j) {
        double a = arr[i];
        arr[i] = arr[j];
        arr[j] = a;
    }

    public static void swap(Object[] arr, int i, int j) {
        Object a = arr[i];
        arr[i] = arr[j];
        arr[j] = a;
    }

    public static void siftUp(int[] arr, int k) {
        while (k > 1 && arr[k / 2] < arr[k]) {
            Sort.swap(arr, k, k / 2);
            k /= 2;
        }
    }

    public static void siftUp(float[] arr, int k) {
        while (k > 1 && arr[k / 2] < arr[k]) {
            Sort.swap(arr, k, k / 2);
            k /= 2;
        }
    }

    public static void siftUp(double[] arr, int k) {
        while (k > 1 && arr[k / 2] < arr[k]) {
            Sort.swap(arr, k, k / 2);
            k /= 2;
        }
    }

    public static <T extends Comparable<? super T>> void siftUp(T[] arr, int k) {
        while (k > 1 && arr[k / 2].compareTo(arr[k]) < 0) {
            Sort.swap(arr, k, k / 2);
            k /= 2;
        }
    }

    public static void siftDown(int[] arr, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && arr[j] < arr[j + 1]) {
                ++j;
            }
            if (arr[k] >= arr[j]) break;
            Sort.swap(arr, k, j);
            k = j;
        }
    }

    public static void siftDown(float[] arr, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && arr[j] < arr[j + 1]) {
                ++j;
            }
            if (arr[k] >= arr[j]) break;
            Sort.swap(arr, k, j);
            k = j;
        }
    }

    public static void siftDown(double[] arr, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && arr[j] < arr[j + 1]) {
                ++j;
            }
            if (arr[k] >= arr[j]) break;
            Sort.swap(arr, k, j);
            k = j;
        }
    }

    public static <T extends Comparable<? super T>> void siftDown(T[] arr, int k, int n) {
        while (2 * k <= n) {
            int j = 2 * k;
            if (j < n && arr[j].compareTo(arr[j + 1]) < 0) {
                ++j;
            }
            if (arr[k].compareTo(arr[j]) >= 0) break;
            Sort.swap(arr, k, j);
            k = j;
        }
    }
}

