/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import smile.sort.Sort;

public class DoubleHeapSelect {
    private int k;
    private int n;
    private boolean sorted;
    private double[] heap;

    public DoubleHeapSelect(int k) {
        this(new double[k]);
    }

    public DoubleHeapSelect(double[] heap) {
        this.heap = heap;
        this.k = heap.length;
        this.n = 0;
        this.sorted = false;
    }

    public void add(double datum) {
        this.sorted = false;
        if (this.n < this.k) {
            this.heap[this.n++] = datum;
            if (this.n == this.k) {
                DoubleHeapSelect.sort(this.heap, this.k);
            }
        } else {
            ++this.n;
            if (datum < this.heap[0]) {
                this.heap[0] = datum;
                Sort.siftDown(this.heap, 0, this.k - 1);
            }
        }
    }

    public double peek() {
        if (this.n < this.k) {
            DoubleHeapSelect.sort(this.heap, this.n);
        }
        return this.heap[0];
    }

    public double get(int i) {
        if (i > Math.min(this.k, this.n) - 1) {
            throw new IllegalArgumentException("HeapSelect i is greater than the number of data received so far.");
        }
        if (i == this.k - 1) {
            return this.heap[0];
        }
        if (!this.sorted) {
            DoubleHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
        return this.heap[this.k - 1 - i];
    }

    public void sort() {
        if (!this.sorted) {
            DoubleHeapSelect.sort(this.heap, Math.min(this.k, this.n));
            this.sorted = true;
        }
    }

    private static void heapify(double[] arr) {
        int n = arr.length;
        for (int i = n / 2 - 1; i >= 0; --i) {
            Sort.siftDown(arr, i, n - 1);
        }
    }

    private static void sort(double[] a, int n) {
        int inc = 1;
        do {
            inc *= 3;
        } while (++inc <= n);
        do {
            for (int i = inc /= 3; i < n; ++i) {
                double v = a[i];
                int j = i;
                while (a[j - inc] < v) {
                    a[j] = a[j - inc];
                    if ((j -= inc) >= inc) continue;
                }
                a[j] = v;
            }
        } while (inc > 1);
    }
}

