/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.distance.Metric;

public class LeeDistance
implements Metric<int[]> {
    private static final long serialVersionUID = 1L;
    private int q;

    public LeeDistance(int q) {
        if (q < 2) {
            throw new IllegalArgumentException(String.format("The size of q-ary alphabet has to be larger than 1: q = %d", q));
        }
        this.q = q;
    }

    public String toString() {
        return String.format("Lee Distance(q = %d)", this.q);
    }

    @Override
    public double d(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int dist = 0;
        for (int i = 0; i < x.length; ++i) {
            double d = Math.abs(x[i] - y[i]);
            dist = (int)((double)dist + Math.min(d, (double)this.q - d));
        }
        return dist;
    }
}

