/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.DifferentiableMultivariateFunction;

public abstract class AbstractDifferentiableMultivariateFunction
implements DifferentiableMultivariateFunction {
    private static final double EPS = 1.0E-8;

    @Override
    public double g(double[] x, double[] gradient) {
        double f = this.applyAsDouble(x);
        double[] xh = (double[])x.clone();
        for (int j = 0; j < x.length; ++j) {
            double temp = x[j];
            double h = 1.0E-8 * Math.abs(temp);
            if (h == 0.0) {
                h = 1.0E-8;
            }
            xh[j] = temp + h;
            h = xh[j] - temp;
            double fh = this.applyAsDouble(xh);
            xh[j] = temp;
            gradient[j] = (fh - f) / h;
        }
        return f;
    }
}

