/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.io.Serializable;
import java.util.Iterator;
import smile.math.SparseArray;
import smile.math.distance.Metric;

public class SparseChebyshevDistance
implements Metric<SparseArray>,
Serializable {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "Chebyshev distance";
    }

    @Override
    public double d(SparseArray x, SparseArray y) {
        double d;
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double dist = 0.0;
        while (a != null && b != null) {
            if (a.i < b.i) {
                d = Math.abs(a.x);
                if (dist < d) {
                    dist = d;
                }
                a = iterX.hasNext() ? iterX.next() : null;
                continue;
            }
            if (a.i > b.i) {
                d = Math.abs(b.x);
                if (dist < d) {
                    dist = d;
                }
                b = iterY.hasNext() ? iterY.next() : null;
                continue;
            }
            d = Math.abs(a.x - b.x);
            if (dist < d) {
                dist = d;
            }
            a = iterX.hasNext() ? iterX.next() : null;
            b = iterY.hasNext() ? iterY.next() : null;
        }
        while (a != null) {
            d = Math.abs(a.x);
            if (dist < d) {
                dist = d;
            }
            a = iterX.hasNext() ? iterX.next() : null;
        }
        while (b != null) {
            d = Math.abs(b.x);
            if (dist < d) {
                dist = d;
            }
            b = iterY.hasNext() ? iterY.next() : null;
        }
        return Math.sqrt(dist);
    }
}

