/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.io.Serializable;
import smile.math.distance.Metric;

public class MinkowskiDistance
implements Metric<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int p;
    private double[] weight = null;

    public MinkowskiDistance(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException(String.format("The order p has to be larger than 0: p = d", p));
        }
        this.p = p;
    }

    public MinkowskiDistance(int p, double[] weight) {
        if (p <= 0) {
            throw new IllegalArgumentException(String.format("The order p has to be larger than 0: p = d", p));
        }
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight has to be nonnegative: %f", weight[i]));
        }
        this.p = p;
        this.weight = weight;
    }

    public String toString() {
        return String.format("Minkowski distance (p = %d)", this.p);
    }

    @Override
    public double d(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < x.length; ++i) {
                double d = Math.abs(x[i] - y[i]);
                dist += Math.pow(d, this.p);
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < x.length; ++i) {
                double d = Math.abs(x[i] - y[i]);
                dist += this.weight[i] * Math.pow(d, this.p);
            }
        }
        return Math.pow(dist, 1.0 / (double)this.p);
    }

    @Override
    public double d(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < x.length; ++i) {
                if (Float.isNaN(x[i]) || Float.isNaN(y[i])) continue;
                ++m;
                double d = Math.abs(x[i] - y[i]);
                dist += Math.pow(d, this.p);
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < x.length; ++i) {
                if (Float.isNaN(x[i]) || Float.isNaN(y[i])) continue;
                ++m;
                double d = Math.abs(x[i] - y[i]);
                dist += this.weight[i] * Math.pow(d, this.p);
            }
        }
        dist = (double)n * dist / (double)m;
        return Math.pow(dist, 1.0 / (double)this.p);
    }

    @Override
    public double d(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        if (this.weight == null) {
            for (int i = 0; i < x.length; ++i) {
                if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
                ++m;
                double d = Math.abs(x[i] - y[i]);
                dist += Math.pow(d, this.p);
            }
        } else {
            if (x.length != this.weight.length) {
                throw new IllegalArgumentException(String.format("Input vectors and weight vector have different length: %d, %d", x.length, this.weight.length));
            }
            for (int i = 0; i < x.length; ++i) {
                if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
                ++m;
                double d = Math.abs(x[i] - y[i]);
                dist += this.weight[i] * Math.pow(d, this.p);
            }
        }
        dist = (double)n * dist / (double)m;
        return Math.pow(dist, 1.0 / (double)this.p);
    }
}

