/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import smile.data.type.ArrayType;
import smile.data.type.BooleanType;
import smile.data.type.ByteType;
import smile.data.type.CharType;
import smile.data.type.DataType;
import smile.data.type.DateTimeType;
import smile.data.type.DateType;
import smile.data.type.DecimalType;
import smile.data.type.DoubleType;
import smile.data.type.FloatType;
import smile.data.type.IntegerType;
import smile.data.type.LongType;
import smile.data.type.ObjectType;
import smile.data.type.ShortType;
import smile.data.type.StringType;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.type.TimeType;

public class DataTypes {
    public static BooleanType BooleanType = smile.data.type.BooleanType.instance;
    public static CharType CharType = smile.data.type.CharType.instance;
    public static ByteType ByteType = smile.data.type.ByteType.instance;
    public static ShortType ShortType = smile.data.type.ShortType.instance;
    public static IntegerType IntegerType = smile.data.type.IntegerType.instance;
    public static LongType LongType = smile.data.type.LongType.instance;
    public static FloatType FloatType = smile.data.type.FloatType.instance;
    public static DoubleType DoubleType = smile.data.type.DoubleType.instance;
    public static DecimalType DecimalType = smile.data.type.DecimalType.instance;
    public static StringType StringType = smile.data.type.StringType.instance;
    public static DateType DateType = smile.data.type.DateType.instance;
    public static DateTimeType DateTimeType = smile.data.type.DateTimeType.instance;
    public static TimeType TimeType = smile.data.type.TimeType.instance;
    public static ObjectType ObjectType = smile.data.type.ObjectType.instance;
    public static ObjectType BooleanObjectType = smile.data.type.ObjectType.BooleanObjectType;
    public static ObjectType CharObjectType = smile.data.type.ObjectType.CharObjectType;
    public static ObjectType ByteObjectType = smile.data.type.ObjectType.ByteObjectType;
    public static ObjectType ShortObjectType = smile.data.type.ObjectType.ShortObjectType;
    public static ObjectType IntegerObjectType = smile.data.type.ObjectType.IntegerObjectType;
    public static ObjectType LongObjectType = smile.data.type.ObjectType.LongObjectType;
    public static ObjectType FloatObjectType = smile.data.type.ObjectType.FloatObjectType;
    public static ObjectType DoubleObjectType = smile.data.type.ObjectType.DoubleObjectType;
    public static ArrayType BooleanArrayType = ArrayType.BooleanArrayType;
    public static ArrayType CharArrayType = ArrayType.CharArrayType;
    public static ArrayType ByteArrayType = ArrayType.ByteArrayType;
    public static ArrayType ShortArrayType = ArrayType.ShortArrayType;
    public static ArrayType IntegerArrayType = ArrayType.IntegerArrayType;
    public static ArrayType LongArrayType = ArrayType.LongArrayType;
    public static ArrayType FloatArrayType = ArrayType.FloatArrayType;
    public static ArrayType DoubleArrayType = ArrayType.DoubleArrayType;

    public static DateType date(String pattern) {
        return new DateType(pattern);
    }

    public static TimeType time(String pattern) {
        return new TimeType(pattern);
    }

    public static DateTimeType datetime(String pattern) {
        return new DateTimeType(pattern);
    }

    public static DataType object(Class clazz) {
        if (clazz == Integer.class) {
            return IntegerObjectType;
        }
        if (clazz == Long.class) {
            return LongObjectType;
        }
        if (clazz == Float.class) {
            return FloatObjectType;
        }
        if (clazz == Double.class) {
            return DoubleObjectType;
        }
        if (clazz == Boolean.class) {
            return BooleanObjectType;
        }
        if (clazz == Character.class) {
            return CharObjectType;
        }
        if (clazz == Byte.class) {
            return ByteObjectType;
        }
        if (clazz == Short.class) {
            return ShortObjectType;
        }
        if (clazz == BigDecimal.class) {
            return DecimalType;
        }
        if (clazz == String.class) {
            return StringType;
        }
        if (clazz == LocalDate.class) {
            return DateType;
        }
        if (clazz == LocalTime.class) {
            return TimeType;
        }
        if (clazz == LocalDateTime.class) {
            return DateTimeType;
        }
        return new ObjectType(clazz);
    }

    public static ArrayType array(DataType type) {
        if (type == IntegerType) {
            return IntegerArrayType;
        }
        if (type == LongType) {
            return LongArrayType;
        }
        if (type == FloatType) {
            return FloatArrayType;
        }
        if (type == DoubleType) {
            return DoubleArrayType;
        }
        if (type == BooleanType) {
            return BooleanArrayType;
        }
        if (type == CharType) {
            return CharArrayType;
        }
        if (type == ByteType) {
            return ByteArrayType;
        }
        if (type == ShortType) {
            return ShortArrayType;
        }
        return new ArrayType(type);
    }

    public static StructType struct(StructField ... fields) {
        return new StructType(fields);
    }

    public static StructType struct(List<StructField> fields) {
        return new StructType(fields);
    }

    public static StructType struct(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        String dbms = rs.getStatement().getConnection().getMetaData().getDatabaseProductName();
        return DataTypes.struct(meta, dbms);
    }

    public static StructType struct(ResultSetMetaData meta, String dbms) throws SQLException {
        int ncols = meta.getColumnCount();
        StructField[] fields = new StructField[ncols];
        for (int i = 1; i <= ncols; ++i) {
            String name = meta.getColumnName(i);
            DataType type = DataType.of(JDBCType.valueOf(meta.getColumnType(i)), meta.isNullable(i) != 0, dbms);
            fields[i - 1] = new StructField(name, type);
        }
        return DataTypes.struct(fields);
    }
}

