/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import smile.data.Tuple;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.StructField;
import smile.data.type.StructType;

final class Variable
implements Term {
    private final String name;

    public Variable(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Variable) {
            return this.name.equals(((Variable)o).name);
        }
        return false;
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public List<Feature> bind(final StructType schema) {
        Feature feature = new Feature(){
            private int index;
            private StructField field;
            {
                this.index = schema.fieldIndex(Variable.this.name);
                this.field = schema.field(this.index);
            }

            @Override
            public boolean isVariable() {
                return true;
            }

            @Override
            public StructField field() {
                return this.field;
            }

            @Override
            public Object apply(Tuple o) {
                return o.get(this.index);
            }

            @Override
            public int applyAsInt(Tuple o) {
                return o.getInt(this.index);
            }

            @Override
            public long applyAsLong(Tuple o) {
                return o.getLong(this.index);
            }

            @Override
            public float applyAsFloat(Tuple o) {
                return o.getFloat(this.index);
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return o.getDouble(this.index);
            }
        };
        return Collections.singletonList(feature);
    }
}

