/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Date;
import smile.data.Attribute;
import smile.data.AttributeVector;
import smile.data.Dataset;
import smile.data.DateAttribute;
import smile.data.Datum;
import smile.data.NumericAttribute;
import smile.math.Math;

public class AttributeDataset
extends Dataset<double[]> {
    private Attribute[] attributes;

    public AttributeDataset(String name, Attribute[] attributes) {
        super(name);
        this.attributes = attributes;
    }

    public AttributeDataset(String name, Attribute[] attributes, Attribute response) {
        super(name, response);
        this.attributes = attributes;
    }

    public Attribute[] attributes() {
        return this.attributes;
    }

    public double[][] x() {
        double[][] x = new double[this.size()][];
        this.toArray((E[])x);
        return x;
    }

    @Override
    public Datum<double[]> add(Datum<double[]> x) {
        if (!(x instanceof Row)) {
            throw new IllegalArgumentException("The added Datum is not of type AttributeDataset.Row");
        }
        return super.add(x);
    }

    public Row add(Row x) {
        this.data.add(x);
        return x;
    }

    public Row add(double[] x) {
        return this.add(new Row(x));
    }

    public Row add(double[] x, int y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        return this.add(new Row(x, (double)y));
    }

    public Row add(double[] x, int y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        return this.add(new Row(x, y, weight));
    }

    public Row add(double[] x, double y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        return this.add(new Row(x, y));
    }

    public Row add(double[] x, double y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        return this.add(new Row(x, y, weight));
    }

    public String toString() {
        int n = 10;
        String s = this.toString(0, n);
        if (this.size() <= n) {
            return s;
        }
        return s + "\n" + (this.size() - n) + " more rows...";
    }

    public AttributeDataset head(int n) {
        return this.range(0, n);
    }

    public AttributeDataset tail(int n) {
        return this.range(this.size() - n, this.size());
    }

    public AttributeDataset range(int from, int to) {
        AttributeDataset sub = new AttributeDataset(this.name + '[' + from + ", " + to + ']', this.attributes, this.response);
        sub.description = this.description;
        for (int i = from; i < to; ++i) {
            sub.add(this.get(i));
        }
        return sub;
    }

    public String toString(int from, int to) {
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
            sb.append(System.getProperty("line.separator"));
        }
        if (this.description != null && !this.description.isEmpty()) {
            sb.append(this.description);
            sb.append(System.getProperty("line.separator"));
        }
        sb.append('\t');
        if (this.response != null) {
            sb.append(this.response.getName());
        }
        int p = this.attributes.length;
        for (int j = 0; j < p; ++j) {
            sb.append('\t');
            sb.append(this.attributes[j].getName());
        }
        int end = Math.min((int)this.data.size(), (int)to);
        for (int i = from; i < end; ++i) {
            sb.append(System.getProperty("line.separator"));
            Datum datum = (Datum)this.data.get(i);
            if (datum.name != null) {
                sb.append(datum.name);
            } else {
                sb.append('[');
                sb.append(i + 1);
                sb.append(']');
            }
            sb.append('\t');
            if (this.response != null) {
                double y = ((Datum)this.data.get((int)i)).y;
                if (this.response.getType() == Attribute.Type.NUMERIC) {
                    sb.append(String.format("%1.4f", y));
                } else {
                    sb.append(this.response.toString(y));
                }
            }
            double[] x = (double[])datum.x;
            for (int j = 0; j < p; ++j) {
                sb.append('\t');
                Attribute attr = this.attributes[j];
                if (attr.getType() == Attribute.Type.NUMERIC) {
                    sb.append(String.format("%1.4f", x[j]));
                    continue;
                }
                sb.append(attr.toString(x[j]));
            }
        }
        return sb.toString();
    }

    public AttributeVector column(int i) {
        if (i < 0 || i >= this.attributes.length) {
            throw new IllegalArgumentException("Invalid column index: " + i);
        }
        double[] vector = new double[this.size()];
        for (int j = 0; j < vector.length; ++j) {
            vector[j] = ((double[])((Datum)this.data.get((int)j)).x)[i];
        }
        return new AttributeVector(this.attributes[i], vector);
    }

    public AttributeVector column(String col) {
        int i = -1;
        for (int j = 0; j < this.attributes.length; ++j) {
            if (!this.attributes[j].getName().equals(col)) continue;
            i = j;
            break;
        }
        if (i == -1) {
            throw new IllegalArgumentException("Invalid column name: " + col);
        }
        return this.column(i);
    }

    public AttributeDataset columns(String ... cols) {
        Attribute[] attrs = new Attribute[cols.length];
        int[] index = new int[cols.length];
        for (int k = 0; k < cols.length; ++k) {
            for (int j = 0; j < this.attributes.length; ++j) {
                if (!this.attributes[j].getName().equals(cols[k])) continue;
                index[k] = j;
                attrs[k] = this.attributes[j];
                break;
            }
            if (attrs[k] != null) continue;
            throw new IllegalArgumentException("Unknown column: " + cols[k]);
        }
        AttributeDataset sub = new AttributeDataset(this.name, attrs, this.response);
        for (Datum datum : this.data) {
            double[] x = new double[index.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = ((double[])datum.x)[index[i]];
            }
            Row row = this.response == null ? sub.add(x) : sub.add(x, datum.y);
            row.name = datum.name;
            row.weight = datum.weight;
            row.description = datum.description;
            row.timestamp = datum.timestamp;
        }
        return sub;
    }

    public AttributeDataset remove(String ... cols) {
        Attribute[] attrs = new Attribute[cols.length];
        int[] index = new int[cols.length];
        int i = 0;
        for (int j = 0; j < this.attributes.length; ++j) {
            boolean hit = false;
            for (int k = 0; k < cols.length; ++k) {
                if (!this.attributes[j].getName().equals(cols[k])) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            index[i] = j;
            attrs[i] = this.attributes[j];
            ++i;
        }
        AttributeDataset sub = new AttributeDataset(this.name, attrs, this.response);
        for (Datum datum : this.data) {
            double[] x = new double[index.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = ((double[])datum.x)[index[i2]];
            }
            Row row = this.response == null ? sub.add(x) : sub.add(x, datum.y);
            row.name = datum.name;
            row.weight = datum.weight;
            row.description = datum.description;
            row.timestamp = datum.timestamp;
        }
        return sub;
    }

    public AttributeDataset summary() {
        Attribute[] attr = new Attribute[]{new NumericAttribute("min"), new NumericAttribute("q1"), new NumericAttribute("median"), new NumericAttribute("mean"), new NumericAttribute("q3"), new NumericAttribute("max")};
        AttributeDataset stat = new AttributeDataset(this.name + " Summary", attr);
        for (int i = 0; i < this.attributes.length; ++i) {
            double[] x = this.column(i).vector();
            double[] s = new double[attr.length];
            s[0] = Math.min((double[])x);
            s[1] = Math.q1((double[])x);
            s[2] = Math.median((double[])x);
            s[3] = Math.mean((double[])x);
            s[4] = Math.q3((double[])x);
            s[5] = Math.max((double[])x);
            Row datum = new Row(s);
            datum.name = this.attributes[i].getName();
            datum.description = this.attributes[i].getDescription();
            stat.add(datum);
        }
        return stat;
    }

    public class Row
    extends Datum<double[]> {
        public Row(double[] x) {
            super(x);
        }

        public Row(double[] x, double y) {
            super(x, y);
        }

        public Row(double[] x, double y, double weight) {
            super(x, y, weight);
        }

        public String label() {
            if (AttributeDataset.this.response.getType() != Attribute.Type.NOMINAL) {
                throw new IllegalStateException("The response is not of nominal type");
            }
            return AttributeDataset.this.response.toString(this.y);
        }

        public String string(int i) {
            return AttributeDataset.this.attributes[i].toString(((double[])this.x)[i]);
        }

        public Date date(int i) {
            if (AttributeDataset.this.attributes[i].getType() != Attribute.Type.DATE) {
                throw new IllegalStateException("Attribute is not of date type");
            }
            return ((DateAttribute)AttributeDataset.this.attributes[i]).toDate(((double[])this.x)[i]);
        }

        public String toString() {
            int j;
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append('\t');
            }
            if (AttributeDataset.this.response != null) {
                sb.append(AttributeDataset.this.response.getName());
            }
            int p = AttributeDataset.this.attributes.length;
            for (j = 0; j < p; ++j) {
                sb.append('\t');
                sb.append(AttributeDataset.this.attributes[j].getName());
            }
            sb.append(System.getProperty("line.separator"));
            if (this.name != null) {
                sb.append(this.name);
                sb.append('\t');
            }
            if (AttributeDataset.this.response != null) {
                if (AttributeDataset.this.response.getType() == Attribute.Type.NUMERIC) {
                    sb.append(String.format("%1.4f", this.y));
                } else {
                    sb.append(AttributeDataset.this.response.toString(this.y));
                }
            }
            for (j = 0; j < p; ++j) {
                sb.append('\t');
                Attribute attr = AttributeDataset.this.attributes[j];
                if (attr.getType() == Attribute.Type.NUMERIC) {
                    sb.append(String.format("%1.4f", ((double[])this.x)[j]));
                    continue;
                }
                sb.append(attr.toString(((double[])this.x)[j]));
            }
            return sb.toString();
        }
    }
}

