/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.hibernate.dialect;

import java.io.Serializable;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataBuilderInitializer;
import org.hibernate.engine.jdbc.dialect.internal.DialectResolverSet;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.jboss.logging.Logger;
import org.sqlite.hibernate.dialect.SQLiteDialect;

public class SQLiteMetadataBuilderInitializer
implements MetadataBuilderInitializer {
    private static final Logger logger = Logger.getLogger(SQLiteMetadataBuilderInitializer.class);
    private static final SQLiteDialect dialect = new SQLiteDialect();
    private static final DialectResolver resolver = (DialectResolver & Serializable)info -> {
        if (info.getDatabaseName().startsWith("SQLite")) {
            return dialect;
        }
        return null;
    };

    public void contribute(MetadataBuilder metadataBuilder, StandardServiceRegistry serviceRegistry) {
        DialectResolver dialectResolver = (DialectResolver)serviceRegistry.getService(DialectResolver.class);
        if (!(dialectResolver instanceof DialectResolverSet)) {
            logger.warnf("DialectResolver '%s' is not an instance of DialectResolverSet, not registering SQLiteDialect", (Object)dialectResolver);
            return;
        }
        ((DialectResolverSet)dialectResolver).addResolver(resolver);
    }
}

