/*
 * Decompiled with CFR 0.152.
 */
package com.github.guilhe.views;

import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.github.guilhe.views.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CircularProgressView
extends View {
    private static final String TAG = CircularProgressView.class.getSimpleName();
    private static final float ANGLE_OFFSET_FOR_MULTIPLE_ARC_PROGRESS = 6.0f;
    private static final float DEFAULT_VIEW_PADDING_DP = 10.0f;
    private static final float DEFAULT_SHADOW_PADDING_DP = 5.0f;
    private static final float DEFAULT_STROKE_THICKNESS_DP = 10.0f;
    private static final int DEFAULT_MAX_WIDTH_DP = 100;
    private static final int DEFAULT_MAX = 100;
    private static final int DEFAULT_STARTING_ANGLE = 270;
    private static final int DEFAULT_ANIMATION_MILLIS = 1000;
    private static final int DEFAULT_PROGRESS_COLOR = -16777216;
    private static final float DEFAULT_BACKGROUND_ALPHA = 0.3f;
    private static final TimeInterpolator DEFAULT_INTERPOLATOR = new DecelerateInterpolator();
    private final float mDefaultViewPadding = this.dpToPx(10.0f);
    private final float mDefaultShadowPadding = this.dpToPx(5.0f);
    private final float mDefaultStrokeThickness = this.dpToPx(10.0f);
    private final int mDefaultMaxWidth = this.dpToPx(100.0f);
    private int mMax;
    private boolean mShadowEnabled;
    private boolean mProgressThumbEnabled;
    private int mStartingAngle;
    private boolean mMultipleArcsEnabled;
    private float mProgressListTotal;
    private ArrayList<Float> mProgressList = new ArrayList();
    private ArrayList<Paint> mProgressPaintList = new ArrayList();
    private float mProgress;
    private float mProgressStrokeThickness;
    private float mProgressIconThickness;
    private int mProgressColor;
    private int mBackgroundColor;
    private boolean mBackgroundAlphaEnabled;
    private boolean mReverseEnabled;
    private boolean mProgressRounded;
    private List<Float> mValuesToDrawList = new ArrayList<Float>();
    private RectF mProgressRectF;
    private RectF mShadowRectF;
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;
    private Paint mShadowPaint;
    private int mLastValidRawMeasuredDim;
    private float mLastValidStrokeThickness;
    private TimeInterpolator mInterpolator;
    private Animator mProgressAnimator;
    private OnProgressChangeAnimationCallback mCallback;
    private Shader mShader;
    private int[] mShaderColors;
    private float[] mShaderPositions;
    private boolean mInitShader;

    public CircularProgressView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircularProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public CircularProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void init(Context context, AttributeSet attrs) {
        this.mLastValidStrokeThickness = this.mDefaultStrokeThickness;
        this.mInterpolator = CircularProgressView.DEFAULT_INTERPOLATOR;
        this.mProgressRectF = new RectF();
        this.mShadowRectF = new RectF();
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mShadowPaint = new Paint(1);
        this.mShadowPaint.setStyle(Paint.Style.STROKE);
        if (attrs != null) {
            typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, 0, 0);
            try {
                this.mMax = typedArray.getInt(R.styleable.CircularProgressView_max, 100);
                this.mShadowEnabled = typedArray.getBoolean(R.styleable.CircularProgressView_shadow, true);
                this.mProgressThumbEnabled = typedArray.getBoolean(R.styleable.CircularProgressView_progressThumb, false);
                this.mStartingAngle = typedArray.getInteger(R.styleable.CircularProgressView_startingAngle, 270);
                this.mProgress = typedArray.getFloat(R.styleable.CircularProgressView_progress, 0.0f);
                this.mProgressStrokeThickness = typedArray.getDimension(R.styleable.CircularProgressView_progressBarThickness, this.mDefaultStrokeThickness);
                this.mProgressColor = typedArray.getInt(R.styleable.CircularProgressView_progressBarColor, -16777216);
                this.mProgressRounded = typedArray.getBoolean(R.styleable.CircularProgressView_progressBarRounded, false);
                this.mBackgroundColor = typedArray.getInt(R.styleable.CircularProgressView_backgroundColor, this.mProgressColor);
                this.mBackgroundAlphaEnabled = typedArray.getBoolean(R.styleable.CircularProgressView_backgroundAlphaEnabled, true);
                this.mReverseEnabled = typedArray.getBoolean(R.styleable.CircularProgressView_reverse, false);
                colorsId = typedArray.getResourceId(R.styleable.CircularProgressView_progressBarColorArray, -1);
                duplicate = typedArray.getBoolean(R.styleable.CircularProgressView_duplicateFirstColorInArray, false);
                if (colorsId != -1) {
                    this.mShaderColors = typedArray.getResources().getIntArray(colorsId);
                    if (duplicate) {
                        this.mShaderColors = this.duplicateFirstColor(this.mShaderColors);
                    }
                    this.mInitShader = true;
                }
                if ((positionsId = typedArray.getResourceId(R.styleable.CircularProgressView_progressBarColorArrayPositions, -1)) == -1) ** GOTO lbl54
                floats = typedArray.getResources().obtainTypedArray(positionsId);
                this.mShaderPositions = new float[floats.length()];
                for (i = 0; i < floats.length(); ++i) {
                    this.mShaderPositions[i] = floats.getFloat(i, 0.0f);
                }
                floats.recycle();
            }
            finally {
                typedArray.recycle();
            }
        } else {
            this.mProgressStrokeThickness = this.mDefaultStrokeThickness;
            this.mShadowEnabled = true;
            this.mMax = 100;
            this.mStartingAngle = 270;
            this.mBackgroundColor = this.mProgressColor = -16777216;
            this.mBackgroundAlphaEnabled = true;
            this.mReverseEnabled = false;
            this.mProgressRounded = false;
            this.mShader = null;
            this.mShaderColors = null;
            this.mShaderPositions = null;
        }
lbl54:
        // 3 sources

        this.resetBackgroundPaint();
        this.mProgressPaint.setColor(this.mProgressColor);
        this.setShader(this.mShader);
        this.mProgressPaint.setStrokeCap(this.mProgressRounded != false ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        this.mShadowPaint.setColor(this.adjustAlpha(-16777216, 0.2f));
        this.mShadowPaint.setStrokeCap(this.mProgressPaint.getStrokeCap());
        this.setThickness(this.mProgressStrokeThickness, false);
    }

    public void setSize(int size) {
        this.getLayoutParams().height = size;
        this.requestLayout();
    }

    public void setStartingAngle(int angle) {
        this.mStartingAngle = angle;
        this.invalidate();
    }

    public int getStartingAngle() {
        return this.mStartingAngle;
    }

    public void setMax(int max) {
        this.mMax = max;
        this.invalidate();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setColor(int color) {
        this.setProgressColor(color);
        this.setBackgroundColor(color);
    }

    @RequiresApi(api=23)
    public void setColorResource(@ColorRes int resId) {
        this.setColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public void setColor(Color color) {
        this.setColor(color.toArgb());
    }

    public void setProgressColor(int color) {
        this.mProgressColor = color;
        if (this.mBackgroundColor == -1) {
            this.setBackgroundColor(color);
        }
        this.mProgressPaint.setColor(color);
        this.setShader(null);
        this.invalidate();
    }

    @RequiresApi(api=23)
    public void setProgressColorResource(@ColorRes int resId) {
        this.setProgressColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public void setProgressColor(Color color) {
        this.setProgressColor(color.toArgb());
    }

    public void setProgressColors(@NonNull @ColorInt int[] colors, @Nullable float[] positions, boolean duplicateFirst) {
        if (duplicateFirst) {
            colors = this.duplicateFirstColor(colors);
        }
        this.mShaderColors = colors;
        this.mShaderPositions = positions;
        this.setShader((Shader)new SweepGradient(this.mProgressRectF.centerX(), this.mProgressRectF.centerY(), colors, positions));
        this.invalidate();
    }

    public void setProgressColors(@NonNull @ColorInt int[] colors, @Nullable float[] positions) {
        this.setProgressColors(colors, positions, false);
    }

    private int[] duplicateFirstColor(@ColorInt @NonNull int[] colors) {
        int[] aux = Arrays.copyOf(colors, colors.length + 1);
        aux[colors.length] = colors[0];
        colors = aux;
        return colors;
    }

    private void setShader(Shader shader) {
        this.mShader = shader;
        this.mProgressPaint.setShader(shader);
    }

    public int getProgressColor() {
        return this.mProgressColor;
    }

    public void setBackgroundColor(int color) {
        this.mBackgroundColor = color;
        this.resetBackgroundPaint();
        this.invalidate();
    }

    public void setBackgroundAlphaEnabled(boolean enabled) {
        this.mBackgroundAlphaEnabled = enabled;
        this.resetBackgroundPaint();
        this.invalidate();
    }

    public boolean isBackgroundAlphaEnabled() {
        return this.mBackgroundAlphaEnabled;
    }

    public void setReverseEnabled(boolean enabled) {
        this.mReverseEnabled = enabled;
        this.invalidate();
    }

    public boolean isReverseEnabled() {
        return this.mReverseEnabled;
    }

    public boolean isProgressRounded() {
        return this.mProgressRounded;
    }

    public void setProgressRounded(boolean enabled) {
        this.mProgressRounded = enabled;
        this.mProgressPaint.setStrokeCap(this.mProgressRounded ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        this.mShadowPaint.setStrokeCap(this.mProgressPaint.getStrokeCap());
        this.invalidate();
    }

    @RequiresApi(api=23)
    public void setShadowColorResource(@ColorRes int resId) {
        this.setBackgroundColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.toArgb());
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setShadowEnabled(boolean enable) {
        this.mShadowEnabled = enable;
        this.invalidate();
    }

    public boolean isShadowEnabled() {
        return this.mShadowEnabled;
    }

    public void setProgressThumbEnabled(boolean enable) {
        this.mProgressThumbEnabled = enable;
        this.invalidate();
    }

    public boolean isProgressThumbEnabled() {
        return this.mProgressThumbEnabled;
    }

    public void setProgressStrokeThickness(float thickness) {
        this.setThickness(thickness, true);
    }

    private void setThickness(float thickness, boolean requestLayout) {
        this.mProgressStrokeThickness = thickness;
        this.mProgressIconThickness = this.mProgressStrokeThickness / 2.0f;
        this.mBackgroundPaint.setStrokeWidth(this.mProgressStrokeThickness);
        this.mProgressPaint.setStrokeWidth(this.mProgressStrokeThickness);
        if (this.mProgressPaintList != null) {
            for (Paint paint : this.mProgressPaintList) {
                paint.setStrokeWidth(this.mProgressStrokeThickness);
            }
        }
        this.mShadowPaint.setStrokeWidth(this.mProgressStrokeThickness);
        if (requestLayout) {
            this.requestLayout();
        }
    }

    public float getProgressStrokeThickness() {
        return this.mProgressStrokeThickness;
    }

    public void setProgress(float progress) {
        this.setProgress(progress, false);
    }

    public void setProgress(float progress, boolean animate) {
        this.setProgress(progress, animate, 1000L);
    }

    public void setProgress(float progress, boolean animate, long duration) {
        this.setProgress(progress, animate, duration, true);
    }

    public void setProgress(@NonNull List<Float> progressList, @NonNull List<Integer> progressColorList) throws RuntimeException {
        this.setProgressRounded(false);
        this.mProgressListTotal = 0.0f;
        this.mProgress = 0.0f;
        for (float value : progressList) {
            this.mProgressListTotal += value;
            if (!(this.mProgressListTotal > (float)this.mMax)) continue;
            throw new RuntimeException(String.format("Progress entities sum (%s) is greater than max value (%s)", Float.valueOf(this.mProgressListTotal), this.mMax));
        }
        this.mMultipleArcsEnabled = true;
        this.mProgressList = new ArrayList<Float>(progressList);
        this.mProgressPaintList = new ArrayList();
        for (int i = 0; i < this.mProgressList.size(); ++i) {
            Paint paint = new Paint(1);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(i < progressColorList.size() ? progressColorList.get(i) : 0);
            this.mProgressPaintList.add(paint);
        }
        this.setThickness(this.mProgressStrokeThickness, false);
        this.invalidate();
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void resetProgress() {
        this.setProgress(0.0f);
    }

    public void resetProgress(boolean animate) {
        this.resetProgress(animate, 1000L);
    }

    public void resetProgress(boolean animate, long duration) {
        this.setProgress(0.0f, animate, duration, false);
    }

    public void setAnimationInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator == null ? DEFAULT_INTERPOLATOR : interpolator;
    }

    public void setProgressAnimationCallback(OnProgressChangeAnimationCallback callback) {
        this.mCallback = callback;
    }

    private void resetBackgroundPaint() {
        this.mBackgroundPaint.setColor(this.mBackgroundAlphaEnabled ? this.adjustAlpha(this.mBackgroundColor, 0.3f) : this.mBackgroundColor);
    }

    private void setProgress(float progress, boolean animate, long duration, boolean clockwise) {
        this.mMultipleArcsEnabled = false;
        if (animate) {
            if (this.mProgressAnimator != null) {
                this.mProgressAnimator.cancel();
            }
            this.mProgressAnimator = this.getAnimator(this.getProgress(), clockwise ? (double)progress : 0.0, duration, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CircularProgressView.this.setProgressValue(((Float)valueAnimator.getAnimatedValue()).floatValue());
                    if (CircularProgressView.this.mCallback != null) {
                        CircularProgressView.this.mCallback.onProgressChanged(CircularProgressView.this.mProgress);
                    }
                }
            });
            this.mProgressAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationEnd(Animator animation) {
                    if (CircularProgressView.this.mCallback != null) {
                        CircularProgressView.this.mCallback.onAnimationFinished(CircularProgressView.this.mProgress);
                    }
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mProgressAnimator.start();
        } else {
            this.setProgressValue(progress);
        }
    }

    private void setProgressValue(float value) {
        this.mProgress = value;
        this.invalidate();
    }

    private ValueAnimator getAnimator(double current, double next, long duration, ValueAnimator.AnimatorUpdateListener updateListener) {
        ValueAnimator animator = new ValueAnimator();
        animator.setInterpolator(this.mInterpolator);
        animator.setDuration(duration);
        animator.setObjectValues(new Object[]{current, next});
        animator.setEvaluator((TypeEvaluator)new FloatEvaluator(){

            public Integer evaluate(float fraction, float startValue, float endValue) {
                return Math.round(startValue + (endValue - startValue) * fraction);
            }
        });
        animator.addUpdateListener(updateListener);
        return animator;
    }

    private int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) : this.mDefaultMaxWidth;
        int rawMeasuredDim = Math.max(Math.min(width, height), 0);
        float arcDim = this.mProgressStrokeThickness + this.mDefaultViewPadding;
        this.mProgressRectF.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
        if (this.mProgressRectF.width() <= this.mProgressStrokeThickness) {
            rawMeasuredDim = this.mLastValidRawMeasuredDim;
            this.mProgressRectF.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
            this.setThickness(this.mLastValidStrokeThickness, false);
        }
        this.mLastValidRawMeasuredDim = rawMeasuredDim;
        this.mLastValidStrokeThickness = this.mProgressStrokeThickness;
        this.mShadowRectF.set(this.mProgressRectF.left, this.mDefaultShadowPadding + this.mProgressRectF.top, this.mProgressRectF.right, this.mDefaultShadowPadding + this.mProgressRectF.bottom);
        this.setMeasuredDimension(rawMeasuredDim, rawMeasuredDim);
    }

    protected synchronized void onDraw(Canvas canvas) {
        double endY;
        double endX;
        float angle;
        super.onDraw(canvas);
        this.mValuesToDrawList.clear();
        if (!this.mMultipleArcsEnabled) {
            this.mValuesToDrawList.add(Float.valueOf(this.mProgress));
            this.mProgressPaintList.clear();
            this.mProgressPaintList.add(this.mProgressPaint);
        } else {
            this.mValuesToDrawList.addAll(this.mProgressList);
        }
        float previousAngle = this.mStartingAngle;
        float radius = (float)(this.getWidth() / 2) - this.mDefaultViewPadding - this.mProgressIconThickness - this.mProgressStrokeThickness / 2.0f;
        if (this.mShadowEnabled) {
            angle = 360.0f * (this.mMultipleArcsEnabled ? this.mProgressListTotal : this.mProgress) / (float)this.mMax;
            if (this.mReverseEnabled) {
                angle *= -1.0f;
            }
            if (!this.mMultipleArcsEnabled && this.mProgressThumbEnabled) {
                endX = Math.cos(Math.toRadians(previousAngle + angle)) * (double)radius;
                endY = Math.sin(Math.toRadians(previousAngle + angle)) * (double)radius;
                canvas.drawCircle((float)endX + this.mShadowRectF.centerX(), (float)endY + this.mShadowRectF.centerY(), this.mProgressIconThickness, this.mShadowPaint);
            }
            canvas.drawArc(this.mShadowRectF, previousAngle, angle, false, this.mShadowPaint);
        }
        if (this.mInitShader) {
            this.mInitShader = false;
            this.setShader((Shader)new SweepGradient(this.mProgressRectF.centerX(), this.mProgressRectF.centerY(), this.mShaderColors, this.mShaderPositions));
        }
        for (int i = 0; i < this.mValuesToDrawList.size(); ++i) {
            if (!this.mMultipleArcsEnabled) {
                canvas.drawOval(this.mProgressRectF, this.mBackgroundPaint);
            }
            angle = 360.0f * this.mValuesToDrawList.get(i).floatValue() / (float)this.mMax;
            if (this.mReverseEnabled) {
                angle *= -1.0f;
            }
            float offset = !this.mReverseEnabled && this.mMultipleArcsEnabled ? 6.0f : 0.0f;
            canvas.drawArc(this.mProgressRectF, previousAngle - offset, angle + offset, false, this.mProgressPaintList.get(i));
            if (!this.mMultipleArcsEnabled && this.mProgressThumbEnabled) {
                endX = Math.cos(Math.toRadians(previousAngle + angle)) * (double)radius;
                endY = Math.sin(Math.toRadians(previousAngle + angle)) * (double)radius;
                canvas.drawCircle((float)endX + this.mProgressRectF.centerX(), (float)endY + this.mProgressRectF.centerY(), this.mProgressIconThickness, this.mProgressPaintList.get(i));
            }
            previousAngle += angle;
        }
    }

    public int dpToPx(float dp) {
        return (int)Math.ceil(dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static interface OnProgressChangeAnimationCallback {
        public void onProgressChanged(float var1);

        public void onAnimationFinished(float var1);
    }
}

