/*
 * Decompiled with CFR 0.152.
 */
package io.testcontainers.arangodb.cluster;

import io.testcontainers.arangodb.cluster.ArangoClusterContainer;
import io.testcontainers.arangodb.containers.ArangoContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArangoCluster {
    private final List<ArangoClusterContainer> coordinators;
    private final ArangoClusterContainer agentLeader;
    private final List<ArangoClusterContainer> agents;
    private final List<ArangoClusterContainer> databases;

    public ArangoCluster(List<ArangoClusterContainer> containers) {
        this.coordinators = Collections.unmodifiableList(containers.stream().filter(c -> c.getType().equals((Object)ArangoClusterContainer.NodeType.COORDINATOR)).collect(Collectors.toList()));
        this.agents = Collections.unmodifiableList(containers.stream().filter(c -> c.getType().equals((Object)ArangoClusterContainer.NodeType.AGENT)).collect(Collectors.toList()));
        this.agentLeader = containers.stream().filter(c -> c.getType().equals((Object)ArangoClusterContainer.NodeType.AGENT_LEADER)).findFirst().orElseThrow(() -> new IllegalArgumentException("Agent leader is not present!"));
        this.databases = Collections.unmodifiableList(containers.stream().filter(c -> c.getType().equals((Object)ArangoClusterContainer.NodeType.DBSERVER)).collect(Collectors.toList()));
    }

    public List<ArangoClusterContainer> getNodes() {
        return Stream.of(this.getAgents(), this.getCoordinators(), this.getDatabases()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ArangoClusterContainer> getCoordinators() {
        return this.coordinators;
    }

    public ArangoClusterContainer getCoordinator(int i) {
        return this.getCoordinators().get(i);
    }

    public List<ArangoClusterContainer> getAgents() {
        return Stream.of(Collections.singletonList(this.agentLeader), this.agents).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public ArangoClusterContainer getAgent(int i) {
        return this.getAgents().get(i);
    }

    public List<ArangoClusterContainer> getDatabases() {
        return this.databases;
    }

    public ArangoClusterContainer getDatabase(int i) {
        return this.getDatabases().get(i);
    }

    public List<Integer> getCoordinatorPorts() {
        return this.getCoordinators().stream().map(ArangoContainer::getPort).collect(Collectors.toList());
    }

    public List<Integer> getAgentPorts() {
        return this.getAgents().stream().map(ArangoContainer::getPort).collect(Collectors.toList());
    }

    public List<Integer> getDatabasePorts() {
        return this.getDatabases().stream().map(ArangoContainer::getPort).collect(Collectors.toList());
    }

    public ArangoClusterContainer getAgentLeader() {
        return this.agentLeader;
    }

    public int getAgentLeaderPort() {
        return this.getAgentLeader().getPort();
    }

    public ArangoClusterContainer getAgent1() {
        return this.getAgentLeader();
    }

    public ArangoClusterContainer getAgent2() {
        return this.agents.get(0);
    }

    public ArangoClusterContainer getAgent3() {
        return this.agents.get(1);
    }

    public ArangoClusterContainer getDatabase1() {
        return this.databases.get(0);
    }

    public ArangoClusterContainer getDatabase2() {
        return this.databases.get(1);
    }

    public ArangoClusterContainer getCoordinator1() {
        return this.coordinators.get(0);
    }

    public ArangoClusterContainer getCoordinator2() {
        return this.coordinators.get(1);
    }
}

