/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.internal;

import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import sharpen.core.Annotations;
import sharpen.core.Bindings;
import sharpen.core.framework.BindingUtils;
import sharpen.core.framework.Environments;
import sharpen.core.framework.JavadocUtility;

public class AnnotationsImpl
implements Annotations {
    private final CompilationUnit _ast = Environments.my(CompilationUnit.class);
    private final Bindings _bindings = Environments.my(Bindings.class);

    @Override
    public TagElement effectiveAnnotationFor(BodyDeclaration node, String annotation) {
        TagElement eventTag = this.javadocTagFor(node, annotation);
        if (null != eventTag) {
            return eventTag;
        }
        if (node instanceof MethodDeclaration) {
            MethodDeclaration originalMethod = this.findOriginalMethodDeclaration((MethodDeclaration)node);
            if (null == originalMethod) {
                return null;
            }
            return this.javadocTagFor((BodyDeclaration)originalMethod, annotation);
        }
        if (node instanceof AnnotationTypeMemberDeclaration) {
            AnnotationTypeMemberDeclaration originalMember = this.findOriginalMemberDeclaration((AnnotationTypeMemberDeclaration)node);
            if (null == originalMember) {
                return null;
            }
            return this.javadocTagFor((BodyDeclaration)originalMember, annotation);
        }
        throw new UnsupportedOperationException();
    }

    private TagElement javadocTagFor(BodyDeclaration method, String annotation) {
        return JavadocUtility.getJavadocTag(method, annotation);
    }

    private MethodDeclaration findOriginalMethodDeclaration(MethodDeclaration node) {
        return (MethodDeclaration)this.findOriginalMethodDeclaration(node.resolveBinding());
    }

    private BodyDeclaration findOriginalMethodDeclaration(IMethodBinding binding) {
        IMethodBinding definition = BindingUtils.findMethodDefininition(binding, this._ast.getAST());
        if (null == definition) {
            return null;
        }
        return (BodyDeclaration)this._bindings.findDeclaringNode((IBinding)definition);
    }

    private AnnotationTypeMemberDeclaration findOriginalMemberDeclaration(AnnotationTypeMemberDeclaration node) {
        return (AnnotationTypeMemberDeclaration)this.findOriginalMethodDeclaration(node.resolveBinding());
    }

    @Override
    public String annotatedPropertyName(MethodDeclaration node) {
        TagElement propertyTag = this.effectiveAnnotationFor((BodyDeclaration)node, "@sharpen.property");
        if (JavadocUtility.hasSingleTextFragment(propertyTag)) {
            return JavadocUtility.singleTextFragmentFrom(propertyTag);
        }
        return null;
    }

    @Override
    public String annotatedRenaming(BodyDeclaration node) {
        TagElement renameTag = JavadocUtility.getJavadocTag(node, "@sharpen.rename");
        if (null == renameTag) {
            return null;
        }
        return JavadocUtility.singleTextFragmentFrom(renameTag);
    }
}

