/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSMethodBase;
import sharpen.core.csharp.ast.CSMethodModifier;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeParameterProvider;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSVariableDeclaration;
import sharpen.core.csharp.ast.CSVisitor;

public class CSMethod
extends CSMethodBase
implements CSTypeParameterProvider {
    private CSMethodModifier _modifier = CSMethodModifier.None;
    private CSTypeReferenceExpression _returnType;
    private List<CSTypeParameter> _typeParameters = new ArrayList<CSTypeParameter>();

    public CSMethod(String name) {
        super(name);
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public void modifier(CSMethodModifier modifier) {
        this._modifier = modifier;
    }

    public CSMethodModifier modifier() {
        return this._modifier;
    }

    public void returnType(CSTypeReferenceExpression returnType) {
        this._returnType = returnType;
    }

    public CSTypeReferenceExpression returnType() {
        return this._returnType;
    }

    public boolean isAbstract() {
        return CSMethodModifier.Abstract == this._modifier || CSMethodModifier.AbstractOverride == this._modifier;
    }

    @Override
    public void addTypeParameter(CSTypeParameter typeParameter) {
        this._typeParameters.add(typeParameter);
    }

    @Override
    public List<CSTypeParameter> typeParameters() {
        return Collections.unmodifiableList(this._typeParameters);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CSMethod) {
            CSMethod other = (CSMethod)o;
            boolean retval = other._name.equals(this._name);
            retval = retval && other._visibility == this._visibility;
            retval = retval && other._returnType.equals(this._returnType);
            retval = retval && other._modifier == this._modifier;
            List<CSVariableDeclaration> params = other.parameters();
            List<CSVariableDeclaration> myParams = this.parameters();
            retval = retval && params.size() == myParams.size();
            for (int i = 0; retval && i < params.size(); ++i) {
                retval = retval && params.get(i).type().equals(myParams.get(i).type());
            }
            return retval;
        }
        return false;
    }
}

