/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import sharpen.core.Configuration;
import sharpen.core.Mappings;
import sharpen.core.NameScope;
import sharpen.core.framework.Environments;

public class CRefBuilder {
    private ASTNode _crefTarget;
    private final ITypeBinding _currentType = Environments.my(NameScope.class).currentType().resolveBinding();

    public CRefBuilder(ASTNode ref) {
        this._crefTarget = ref;
    }

    public String build() {
        switch (this._crefTarget.getNodeType()) {
            case 40: 
            case 42: {
                return this.mapCRefTarget(this._crefTarget, ((Name)this._crefTarget).resolveBinding());
            }
            case 67: {
                return this.mapCRefTarget(this._crefTarget, ((MemberRef)this._crefTarget).resolveBinding());
            }
            case 68: {
                return this.mapCRefTarget(this._crefTarget, ((MethodRef)this._crefTarget).resolveBinding());
            }
        }
        return null;
    }

    private String mapCRefTarget(ASTNode node, IBinding binding) {
        if (null == binding) {
            Environments.my(Configuration.class).getWarningHandler().warning(node, "Unresolved cref target");
            return node.toString();
        }
        return this.documentationNameFor(binding);
    }

    private String documentationNameFor(IBinding binding) {
        switch (binding.getKind()) {
            case 4: {
                return this.methodSignatureForDocumentation((IMethodBinding)binding);
            }
            case 2: {
                return this.mappedTypeName((ITypeBinding)binding);
            }
            case 3: {
                return this.mappedQualifiedFieldName((IVariableBinding)binding);
            }
            case 1: {
                return this.mappedNamespace(((IPackageBinding)binding).getName());
            }
        }
        throw new IllegalArgumentException("Binding type not supported: " + binding);
    }

    private String methodSignatureForDocumentation(IMethodBinding method) {
        StringBuilder methodFQN = new StringBuilder();
        if (this.belongsToCurrentType(method)) {
            methodFQN.append(this.mappedMethodName(method));
        } else {
            methodFQN.append(this.mappedQualifiedMethodName(method));
        }
        String parameterList = this.parameterListSeparatedBy(method, ", ");
        methodFQN.append(this.genericTypeParametersFor(method));
        methodFQN.append("(");
        methodFQN.append(parameterList);
        methodFQN.append(")");
        return methodFQN.toString();
    }

    private boolean belongsToCurrentType(IMethodBinding method) {
        return this._currentType == method.getDeclaringClass();
    }

    private String mappedQualifiedMethodName(IMethodBinding binding) {
        String methodName = this.mappedMethodName(binding);
        if (methodName.indexOf(46) > -1) {
            return methodName;
        }
        return this.mappedTypeName(binding.getDeclaringClass()) + "." + methodName;
    }

    private String genericTypeParametersFor(IMethodBinding method) {
        IMethodBinding bind = method.getMethodDeclaration();
        return this.genericQualifierFor(bind.getTypeParameters());
    }

    private String genericQualifierFor(ITypeBinding[] typeParameters) {
        if (typeParameters.length == 0) {
            return "";
        }
        return "{" + this.typesSeparatedBy(typeParameters, ", ") + "}";
    }

    private String parameterListSeparatedBy(IMethodBinding binding, String separator) {
        return this.typesSeparatedBy(binding.getParameterTypes(), separator);
    }

    private String typesSeparatedBy(ITypeBinding[] types, String separator) {
        StringBuilder result = new StringBuilder();
        for (ITypeBinding parameter : types) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(this.mappedTypeName(parameter));
        }
        return result.toString();
    }

    private String mappedMethodName(IMethodBinding binding) {
        return Environments.my(Mappings.class).mappedMethodName(binding);
    }

    private String mappedQualifiedFieldName(IVariableBinding binding) {
        String name = Environments.my(Mappings.class).mappedFieldName(binding);
        if (null != name) {
            return name;
        }
        String fieldName = this.identifier(binding.getName());
        if (this._currentType == binding.getDeclaringClass()) {
            return fieldName;
        }
        return this.mappedTypeName(binding.getDeclaringClass()) + "." + fieldName;
    }

    private String mappedTypeName(ITypeBinding type) {
        if (type.isArray()) {
            int dimensions = type.getDimensions();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[]");
            }
            return this.mappedTypeName(type.getElementType()) + sb;
        }
        String mappedTypeName = Environments.my(Mappings.class).mappedTypeName(type);
        String effectiveTypeName = this._currentType.getPackage() == type.getPackage() ? this.simpleName(mappedTypeName) : mappedTypeName;
        return effectiveTypeName + this.genericQualifierFor(type.getTypeDeclaration().getTypeParameters());
    }

    private String simpleName(String typeName) {
        int lastDot = typeName.lastIndexOf(46);
        return lastDot > 0 ? typeName.substring(lastDot + 1) : typeName;
    }

    private String identifier(String name) {
        return Environments.my(Configuration.class).getNamingStrategy().identifier(name);
    }

    private String mappedNamespace(String namespace) {
        return Environments.my(Configuration.class).mappedNamespace(namespace);
    }
}

