/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.Map;
import parser.Function;
import parser.Variable;
import util.FunctionManager;
import util.Log;
import util.Settings;
import util.VariableManager;
import util.io.FunctionsBackup;
import util.io.TextFileReader;
import util.io.TextFileWriter;
import util.io.VariableBackup;

public class Utils {
    public static File VARIABLES;
    public static File FUNCTIONS;
    public static File SETTINGS;
    public static File APP_FOLDER;
    public static int IMAGE_ICON_SIZE;
    public static boolean loggingEnabled;

    public Utils() {
        String appName = "ParserNG";
        APP_FOLDER = new File(appName);
        VARIABLES = new File(APP_FOLDER.getAbsolutePath(), "variables.txt");
        FUNCTIONS = new File(APP_FOLDER.getAbsolutePath(), "functions.txt");
        SETTINGS = new File(APP_FOLDER.getAbsolutePath(), "settings.txt");
        try {
            if (!APP_FOLDER.exists()) {
                APP_FOLDER.mkdir();
            }
            if (!VARIABLES.exists()) {
                VARIABLES.createNewFile();
            }
            if (!FUNCTIONS.exists()) {
                FUNCTIONS.createNewFile();
            }
            if (!SETTINGS.exists()) {
                SETTINGS.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVariables() {
        Map<String, Variable> map = VariableManager.VARIABLES;
        synchronized (map) {
            VariableBackup.writeMapItemsToFileLineByLine(VariableManager.VARIABLES, VARIABLES);
        }
    }

    public static void loadVariables() {
        VariableBackup.readFileLinesToMap(VariableManager.VARIABLES, VARIABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFunctions() {
        Map<String, Function> map = FunctionManager.FUNCTIONS;
        synchronized (map) {
            FunctionsBackup.writeMapItemsToFileLineByLine(FunctionManager.FUNCTIONS, FUNCTIONS);
        }
    }

    public static void loadFunctions() {
        FunctionsBackup.readFileLinesToMap(FunctionManager.FUNCTIONS, FUNCTIONS);
    }

    public static void saveSettings(Settings settings) {
        String ser = settings.serialize();
        TextFileWriter.writeText(SETTINGS, ser);
    }

    public static Settings loadSettings() {
        String ser = new TextFileReader(SETTINGS).read();
        if (ser == null || ser.isEmpty()) {
            return null;
        }
        return Settings.parse(ser);
    }

    public static void saveAll(final Settings settings) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FunctionManager.initializeFunctionVars();
                Utils.saveVariables();
                Utils.saveFunctions();
                Utils.saveSettings(settings);
            }
        }).start();
    }

    public static void loadAll() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Utils.loadVariables();
                Utils.loadFunctions();
                Utils.loadSettings();
            }
        }).start();
    }

    public static void logError(String message) {
        if (loggingEnabled) {
            Log.e("Kalculitzer", message);
        }
    }

    public static void logDebug(String message) {
        if (loggingEnabled) {
            Log.d("Kalculitzer", message);
        }
    }

    public static void logInfo(String message) {
        if (loggingEnabled) {
            Log.i("Kalculitzer", message);
        }
    }

    static {
        IMAGE_ICON_SIZE = 300;
        loggingEnabled = false;
    }
}

