/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import math.matrix.expressParser.MatrixFunction;

public class MatrixFunctionManager {
    private ArrayList<MatrixFunction> functions = new ArrayList();

    public ArrayList<MatrixFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(ArrayList<MatrixFunction> functions) {
        this.functions = functions;
    }

    public boolean canOptimizeFunction(String name) {
        return this.getFunctionByName(name) != null;
    }

    public void storeFunction(MatrixFunction function) {
        if (!this.contains(function)) {
            this.functions.add(0, function);
        }
    }

    public boolean contains(MatrixFunction func) {
        return this.functions.indexOf(func) != -1;
    }

    public MatrixFunction getFunction(MatrixFunction function) {
        return this.functions.get(this.functions.indexOf(function));
    }

    public MatrixFunction getFunctionAt(int index) {
        if (index >= 0 && index < this.functions.size()) {
            return this.functions.get(index);
        }
        throw new ArrayIndexOutOfBoundsException("Function Store Access Error");
    }

    public MatrixFunction getFunctionByName(String funcName) throws NullPointerException {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (!this.functions.get(i).getExpression().equals(funcName)) continue;
            return this.functions.get(i);
        }
        return null;
    }

    public MatrixFunction getFunctionByScanner(ArrayList<String> scanner) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (this.functions.get(i).getScanner() != scanner) continue;
            return this.functions.get(i);
        }
        return null;
    }

    public void removeFunctionAt(int index) {
        if (this.contains(this.functions.get(index))) {
            this.functions.remove(index);
        }
    }

    public void removeFunctionByName(String funcName) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (!this.functions.get(i).getExpression().equals(funcName)) continue;
            this.functions.remove(i);
        }
    }

    public void removeFunctionByScanner(ArrayList<String> scanner) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (this.functions.get(i).getScanner() != scanner) continue;
            this.functions.remove(i);
        }
    }

    public MatrixFunction optimizeFunction(String name) {
        return this.getFunctionByName(name);
    }
}

