/*
 * Decompiled with CFR 0.152.
 */
package parser;

import interfaces.Savable;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import math.Maths;
import parser.MathExpression;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.TYPE;
import util.Serializer;

public class Variable
implements Savable {
    private String name;
    private TYPE type;
    private String value;
    private String units = "";
    private boolean constant;
    private String fullName;
    public static final Variable PI = new Variable("pi", Maths.PI(), true);
    public static Variable ans = new Variable("ans", "0.0", false);
    public static Variable e = new Variable("e", String.valueOf(Math.E), true);

    public Variable(String name) {
        if (Variable.isVariableString(name)) {
            this.name = name;
            this.value = "0.0";
            this.type = TYPE.NUMBER;
        }
    }

    public Variable(String name, String value, boolean constant) {
        this(name, "", value, constant);
    }

    public Variable(String name, String fullName, String value, boolean constant) {
        if (Variable.isVariableString(name)) {
            this.name = name;
            this.setValue(value);
            this.fullName = fullName;
            this.constant = constant;
        }
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public TYPE getType() {
        return this.type;
    }

    public Variable(String name, double value, boolean constant) {
        this(name, value + "", constant);
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName == null || this.fullName.isEmpty() ? this.name : this.fullName;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isTheta() {
        return this.getName().equals("\u03b8");
    }

    public static boolean isVariableBeginner(String var) {
        return !Operator.isPermOrComb(var) && var.charAt(0) != 'E' && var.charAt(0) != '\u03c0' && (Character.isLetter(var.charAt(0)) || Variable.isTheta(var) || Variable.isPI(var) || Variable.isExpNumber(var) || var.equals("_") || var.equals("$"));
    }

    public static boolean isVariableString(String var) {
        if (var.length() == 1) {
            return Variable.isVariableBeginner(var);
        }
        if (var.length() > 1) {
            if (var.equals("ans")) {
                return true;
            }
            if (var.equals("var") || var.equals("const") || STRING.purifier(var).equals("")) {
                return false;
            }
            if (Operator.isOperatorString(var)) {
                return false;
            }
            if (Variable.isVariableBeginner(var.substring(0, 1))) {
                int sz = var.length();
                for (int i = 0; i < sz; ++i) {
                    if (Variable.isVariableBuilder(var.substring(i, i + 1))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isVariableBuilder(String unit) {
        return Character.isLetterOrDigit(unit.charAt(0)) || Variable.isTheta(unit) || Variable.isPI(unit) || Variable.isExpNumber(unit) || unit.equals("_") || unit.equals("$");
    }

    public static boolean isSystemVar(String str) {
        return str.equals(Variable.ans.name) || str.equals(Variable.e.name) || str.equals(Variable.PI.name);
    }

    public static boolean isSystemConstant(String str) {
        return str.equals("\u03c0") || str.equals("e");
    }

    public static String getSystemConstantValue(String name) {
        if (Variable.isPI(name)) {
            return Maths.PI();
        }
        if (Variable.isExpNumber(name)) {
            return e.getName();
        }
        throw new InputMismatchException("Not System Constant");
    }

    public static boolean isExpNumber(String str) {
        return str.equals("e");
    }

    public static boolean isPI(String str) {
        return str.equals("pi");
    }

    public static boolean isTheta(String str) {
        return str.equals("\u03b8");
    }

    public static boolean isLastEvaluatedAnswer(String str) {
        return str.equals("ans");
    }

    public boolean isSimpleVar() {
        return this.name.length() == 1 && (STRING.isUpperCaseWord(this.name) || this.name.equals("\u03b8"));
    }

    public void setName(String name) {
        if (Variable.isVariableString(name)) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        if (value.contains(" ")) {
            String[] vals = value.split(" ");
            value = vals[0];
            this.units = vals[1];
        }
        if (!Number.validNumber(value)) {
            throw new NumberFormatException("Bad Value! " + value + ".\nVariables store only valid real numbers.");
        }
        this.value = value;
    }

    public String getValue() {
        if (Variable.isPI(this.getName())) {
            this.value = Maths.PI();
            return this.value;
        }
        if (Variable.isLastEvaluatedAnswer(this.getName())) {
            this.value = MathExpression.lastResult;
            return this.value;
        }
        if (Variable.isExpNumber(this.getName())) {
            return this.value;
        }
        if (this.isConstant()) {
            return this.value;
        }
        return this.value;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    public static int getSimpleVarIndex(String var) {
        int index = 0;
        if (var.equals("A")) {
            index = 0;
        } else if (var.equals("B")) {
            index = 1;
        } else if (var.equals("C")) {
            index = 2;
        } else if (var.equals("D")) {
            index = 3;
        } else if (var.equals("E")) {
            index = 4;
        } else if (var.equals("F")) {
            index = 5;
        } else if (var.equals("G")) {
            index = 6;
        } else if (var.equals("H")) {
            index = 7;
        } else if (var.equals("I")) {
            index = 8;
        } else if (var.equals("J")) {
            index = 9;
        } else if (var.equals("K")) {
            index = 10;
        } else if (var.equals("L")) {
            index = 11;
        } else if (var.equals("M")) {
            index = 12;
        } else if (var.equals("N")) {
            index = 13;
        } else if (var.equals("O")) {
            index = 14;
        } else if (var.equals("P")) {
            index = 15;
        } else if (var.equals("Q")) {
            index = 16;
        } else if (var.equals("R")) {
            index = 17;
        } else if (var.equals("S")) {
            index = 18;
        } else if (var.equals("T")) {
            index = 19;
        } else if (var.equals("U")) {
            index = 20;
        } else if (var.equals("V")) {
            index = 21;
        } else if (var.equals("W")) {
            index = 22;
        } else if (var.equals("X")) {
            index = 23;
        } else if (var.equals("Y")) {
            index = 24;
        } else if (var.equals("Z")) {
            index = 25;
        } else if (var.equals("\u03b8")) {
            index = 26;
        } else {
            throw new NoSuchElementException("Only A-Z And The Theta Symbol Are Supported.");
        }
        return index;
    }

    public int getSimpleVarIndex() {
        int index = 0;
        if (this.getName().equals("A")) {
            index = 0;
        } else if (this.getName().equals("B")) {
            index = 1;
        } else if (this.getName().equals("C")) {
            index = 2;
        } else if (this.getName().equals("D")) {
            index = 3;
        } else if (this.getName().equals("E")) {
            index = 4;
        } else if (this.getName().equals("F")) {
            index = 5;
        } else if (this.getName().equals("G")) {
            index = 6;
        } else if (this.getName().equals("H")) {
            index = 7;
        } else if (this.getName().equals("I")) {
            index = 8;
        } else if (this.getName().equals("J")) {
            index = 9;
        } else if (this.getName().equals("K")) {
            index = 10;
        } else if (this.getName().equals("L")) {
            index = 11;
        } else if (this.getName().equals("M")) {
            index = 12;
        } else if (this.getName().equals("N")) {
            index = 13;
        } else if (this.getName().equals("O")) {
            index = 14;
        } else if (this.getName().equals("P")) {
            index = 15;
        } else if (this.getName().equals("Q")) {
            index = 16;
        } else if (this.getName().equals("R")) {
            index = 17;
        } else if (this.getName().equals("S")) {
            index = 18;
        } else if (this.getName().equals("T")) {
            index = 19;
        } else if (this.getName().equals("U")) {
            index = 20;
        } else if (this.getName().equals("V")) {
            index = 21;
        } else if (this.getName().equals("W")) {
            index = 22;
        } else if (this.getName().equals("X")) {
            index = 23;
        } else if (this.getName().equals("Y")) {
            index = 24;
        } else if (this.getName().equals("Z")) {
            index = 25;
        } else if (this.getName().equals("\u03b8")) {
            index = 26;
        } else {
            throw new NoSuchElementException("Only A-Z And The Theta Symbol Are Supported.");
        }
        return index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            return this.getName().equals(((Variable)obj).getName());
        }
        return false;
    }

    public static Variable parse(String enc) {
        return (Variable)Serializer.deserialize(enc);
    }

    @Override
    public String serialize() {
        return Serializer.serialize(this);
    }

    public String toString() {
        return this.name + ":" + this.value;
    }

    public static void main(String[] args) {
        System.out.println(Variable.isVariableString("sin"));
    }

    static {
        Variable.ans.type = TYPE.NUMBER;
        Variable.e.type = TYPE.NUMBER;
        Variable.PI.type = TYPE.NUMBER;
    }
}

