/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import math.BigDecimalNthRootCalculation;
import math.Maths;
import math.differentialcalculus.Derivative;
import math.matrix.expressParser.Matrix;
import math.numericalmethods.NumericalIntegral;
import math.numericalmethods.RootFinder;
import math.quadratic.Quadratic_Equation;
import math.tartaglia.Tartaglia_Equation;
import parser.Bracket;
import parser.Function;
import parser.MathExpression;
import parser.Number;
import parser.STRING;
import parser.Variable;
import parser.methods.ext.Utils;
import util.FunctionManager;
import util.VariableManager;

public class Set {
    private List<String> data = new ArrayList<String>();

    public Set(double ... data) {
        for (int i = 0; i < data.length; ++i) {
            this.data.add(data[i] + "");
        }
    }

    public Set(List<String> data) {
        this.data = data;
    }

    public Set(MathExpression function, List<String> data) {
        this.data = function.solveSubPortions(data);
    }

    public void setData(ArrayList<String> data) {
        this.data = data;
    }

    public List<String> getData() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public double sum() {
        double u = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u += Double.valueOf(this.data.get(i)).doubleValue();
        }
        return u;
    }

    public BigDecimal gsum() {
        return Utils.gsum(Utils.stringsToBigDecimals(this.data));
    }

    public BigDecimal geom() {
        BigDecimal gsum = this.gsum();
        int size = this.size();
        return BigDecimalNthRootCalculation.nthRoot(size, gsum);
    }

    public double sumOfSquares() {
        double u = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u += Math.pow(Double.valueOf(this.data.get(i)), 2.0);
        }
        return u;
    }

    public double prod() {
        double u = 1.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u *= Double.valueOf(this.data.get(i)).doubleValue();
        }
        return u;
    }

    public double min() {
        double minval = Double.valueOf(this.data.get(0));
        for (int i = 0; i < this.data.size(); ++i) {
            double y = Double.valueOf(this.data.get(i));
            if (!(y < minval)) continue;
            minval = y;
        }
        return minval;
    }

    public double max() {
        double maxval = Double.valueOf(this.data.get(0));
        for (int i = 0; i < this.data.size(); ++i) {
            double y = Double.valueOf(this.data.get(i));
            if (!(y > maxval)) continue;
            maxval = y;
        }
        return maxval;
    }

    public double avg() {
        return this.sum() / (double)this.size();
    }

    public double rms() {
        return Math.sqrt(this.sumOfSquares()) / (double)this.size();
    }

    public double rng() {
        return this.max() - this.min();
    }

    public double mrng() {
        return 0.5 * (this.max() + this.min());
    }

    public double var() {
        double u = 0.0;
        double u1 = 0.0;
        double avrg = this.avg();
        double N = this.size();
        int i = 0;
        while ((double)i < N) {
            u = Double.valueOf(this.data.get(i)) - avrg;
            u1 += Math.pow(u, 2.0);
            ++i;
        }
        return u1 / N;
    }

    public double std_dev() {
        return Math.sqrt(this.var());
    }

    public double std_err() {
        return this.std_dev() / Math.sqrt(this.size());
    }

    public String cov() {
        return 100.0 * this.std_dev() / this.avg() + "%";
    }

    private List<String> displayOuputLineByLine() {
        ArrayList<String> sort = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            sort.add(this.data.get(i));
        }
        return sort;
    }

    public List<String> sort() {
        ArrayList<String> sort = new ArrayList<String>();
        double[] array = new double[this.data.size()];
        int count = 0;
        for (String a : this.data) {
            array[count++] = Double.parseDouble(a);
        }
        Arrays.sort(array);
        count = 0;
        for (Object d : (Object)array) {
            String c = String.valueOf((double)d);
            sort.add(c.endsWith(".0") ? c.substring(0, c.length() - 2) : c);
        }
        return sort;
    }

    public Matrix invert() {
        if (this.data.size() == 1) {
            Function f = FunctionManager.lookUp(this.data.get(0));
            return f.calcInverse();
        }
        int size = this.data.size();
        double dimen = Math.sqrt(size);
        if (Math.floor(dimen) == dimen) {
            double[][] arr = new double[(int)dimen][(int)dimen];
            int row = 0;
            int col = 0;
            int dim = (int)dimen;
            for (int i = 0; i < this.data.size(); ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == dim - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr).inverse();
        }
        return new Matrix("");
    }

    public Matrix solveSystem() {
        int numCols;
        if (this.data.size() == 1) {
            Function f = FunctionManager.lookUp(this.data.get(0));
            return f.getMatrix().solveEquation();
        }
        ArrayList result = new ArrayList();
        int size = this.data.size();
        double dimen = Math.sqrt(size);
        int numRows = (int)dimen;
        if (numRows * (numCols = numRows + 1) == size) {
            double[][] arr = new double[numRows][numCols];
            int row = 0;
            int col = 0;
            for (int i = 0; i < size; ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == numCols - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr).solveEquation();
        }
        return null;
    }

    public Matrix listToMatrix() {
        int numRows = Integer.parseInt(this.data.get(0));
        int numCols = Integer.parseInt(this.data.get(1));
        this.data.subList(0, 2).clear();
        int size = this.data.size();
        if (numRows * numCols == size) {
            double[][] arr = new double[numRows][numCols];
            int row = 0;
            int col = 0;
            for (int i = 0; i < size; ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == numCols - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr);
        }
        return null;
    }

    public Matrix echelon() {
        if (this.data.size() == 1) {
            Function f = FunctionManager.lookUp(this.data.get(0));
            return f.reduceToEchelon();
        }
        ArrayList result = new ArrayList();
        int numRows = Integer.parseInt(this.data.get(0));
        int numCols = Integer.parseInt(this.data.get(1));
        this.data.subList(0, 2).clear();
        int size = this.data.size();
        if (numRows * numCols == size) {
            double[][] arr = new double[numRows][numCols];
            int row = 0;
            int col = 0;
            for (int i = 0; i < size; ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == numCols - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr).reduceToRowEchelonMatrix();
        }
        return null;
    }

    public Matrix triMatrix() {
        if (this.data.size() == 1) {
            Function f = FunctionManager.lookUp(this.data.get(0));
            return f.triangularMatrix();
        }
        int numRows = Integer.parseInt(this.data.get(0));
        int numCols = Integer.parseInt(this.data.get(1));
        this.data.subList(0, 2).clear();
        int size = this.data.size();
        if (numRows * numCols == size) {
            double[][] arr = new double[numRows][numCols];
            int row = 0;
            int col = 0;
            for (int i = 0; i < size; ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == numCols - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            return new Matrix(arr).reduceToTriangularMatrix();
        }
        return null;
    }

    public double median() {
        double median = 0.0;
        List<Object> scan = new ArrayList();
        scan = this.sort();
        int g = this.size();
        if (STRING.isEven(g)) {
            double med;
            median = med = (Double.valueOf((String)scan.get(g / 2)) + Double.valueOf((String)scan.get(g / 2 - 1))) / 2.0;
        } else if (!STRING.isEven(g)) {
            median = Double.valueOf((String)scan.get((g - 1) / 2));
        }
        return median;
    }

    public String mode() {
        int[] freq = new int[this.data.size()];
        int g = freq.length;
        int count = 0;
        for (int j = 0; j < g; ++j) {
            for (int i = 0; i < g; ++i) {
                if (Double.parseDouble(this.data.get(i)) != Double.parseDouble(this.data.get(j))) continue;
                ++count;
            }
            freq[j] = count;
            count = 0;
        }
        double big = 0.0;
        for (int i = 0; i < freq.length; ++i) {
            if (!(big < (double)freq[i])) continue;
            big = freq[i];
        }
        ArrayList<String> mode = new ArrayList<String>();
        for (int i = 0; i < freq.length; ++i) {
            if ((double)freq[i] != big || mode.contains(this.data.get(i))) continue;
            mode.add(this.data.get(i));
        }
        String dMode = String.valueOf(mode);
        dMode = STRING.delete(STRING.delete(dMode, "["), "]");
        return dMode;
    }

    public List<String> random() {
        ArrayList<String> vals = new ArrayList<String>();
        Random rnd = new Random();
        if (this.size() == 1) {
            int val = Integer.valueOf(this.data.get(0));
            this.data.set(0, String.valueOf(val));
        } else if (this.size() == 2) {
            double val = Double.valueOf(this.data.get(0));
            double val1 = Double.valueOf(this.data.get(1));
            this.data.set(0, String.valueOf((int)val));
            this.data.set(1, String.valueOf((int)val1));
        }
        if (this.size() == 0) {
            vals.add(String.valueOf(rnd.nextFloat()));
        } else if (this.size() == 1) {
            String num = String.valueOf(rnd.nextInt(Integer.valueOf(this.data.get(0))));
            vals.add(num);
        } else if (this.size() == 2) {
            for (int i = 0; i < Integer.valueOf(this.data.get(1)); ++i) {
                vals.add(String.valueOf(rnd.nextInt(Integer.valueOf(this.data.get(0)))));
            }
        } else {
            throw new NoSuchElementException("Allowed Formats For rnd Are rnd(),rnd1(number),rnd1( number1,number2)");
        }
        this.data.clear();
        this.data.addAll(vals);
        return vals;
    }

    public String permutation() {
        String n = this.data.get(0);
        String r = this.data.get(1);
        double n_Factorial = Double.parseDouble(Maths.fact(n));
        double n_Minus_r_Factorial = Double.parseDouble(Maths.fact(String.valueOf(Double.valueOf(n) - Double.valueOf(r))));
        return String.valueOf(n_Factorial / n_Minus_r_Factorial);
    }

    public String combination() {
        String n = this.data.get(0);
        String r = this.data.get(1);
        double n_Factorial = Double.parseDouble(Maths.fact(n));
        double n_Minus_r_Factorial = Double.parseDouble(Maths.fact(String.valueOf(Double.valueOf(n) - Double.valueOf(r))));
        double r_Factorial = Double.parseDouble(Maths.fact(r));
        return String.valueOf(n_Factorial / (n_Minus_r_Factorial * r_Factorial));
    }

    public String power() {
        double n = Double.parseDouble(this.data.get(0));
        double pow = Double.parseDouble(this.data.get(1));
        return String.valueOf(Math.pow(n, pow));
    }

    public String differentiate() {
        int sz = this.data.size();
        switch (sz) {
            case 1: {
                String anonFunc = this.data.get(0);
                String solution = Derivative.eval("diff(" + anonFunc + ",1)");
                return solution;
            }
            case 2: {
                String anonFunc = this.data.get(0);
                double value = Double.valueOf(this.data.get(1));
                String solution = Derivative.eval("diff(" + anonFunc + "," + value + ")");
                return solution;
            }
            case 3: {
                String anonFunc = this.data.get(0);
                double value = Double.valueOf(this.data.get(1));
                int order = Integer.parseInt(this.data.get(2));
                String solution = Derivative.eval("diff(" + anonFunc + "," + value + "," + order + ")");
                return solution;
            }
        }
        throw new InputMismatchException(" Parameter List " + this.data + " Is Invalid!");
    }

    public String quadraticRoots() {
        int sz = this.data.size();
        String function = "";
        for (int i = 0; i < sz; ++i) {
            function = function.concat(this.data.get(i));
        }
        Function f = FunctionManager.lookUp(function);
        String input = f.expressionForm();
        input = input.substring(1);
        int closeBracOfAt = Bracket.getComplementIndex(true, 0, input);
        if ((input = input.substring(closeBracOfAt + 1)).startsWith("(")) {
            input = input.substring(1, input.length() - 1);
            input = input.concat("=0");
        }
        Quadratic_Equation solver = new Quadratic_Equation(input);
        String soln = solver.solutions();
        return soln;
    }

    public String tartaglianRoots() {
        int sz = this.data.size();
        String function = "";
        for (int i = 0; i < sz; ++i) {
            function = function.concat(this.data.get(i));
        }
        Function f = FunctionManager.lookUp(function);
        String input = f.expressionForm();
        input = input.substring(1);
        int closeBracOfAt = Bracket.getComplementIndex(true, 0, input);
        if ((input = input.substring(closeBracOfAt + 1)).startsWith("(")) {
            input = input.substring(1, input.length() - 1);
            input = input.concat("=0");
        }
        Tartaglia_Equation solver = new Tartaglia_Equation(input);
        String reducedForm = solver.interpretedSystem();
        String soln = solver.solutions();
        return soln;
    }

    public String rootOfEquation() {
        int sz = this.data.size();
        boolean has2NumberArguments = false;
        System.out.println("LIST: " + this.data);
        if (Number.validNumber(this.data.get(sz - 1)) && !Number.validNumber(this.data.get(sz - 2))) {
            has2NumberArguments = true;
        }
        String function = "";
        if (has2NumberArguments) {
            for (int i = 0; i < sz - 1; ++i) {
                function = function.concat(this.data.get(i));
            }
            RootFinder rf = new RootFinder(FunctionManager.lookUp(function), Double.parseDouble(this.data.get(sz - 1)));
            return rf.findRoots();
        }
        return "Function Syntax Error!";
    }

    public String integrate() {
        int sz = this.data.size();
        boolean has3NumberArguments = false;
        boolean has2NumberArguments = false;
        if (Number.validNumber(this.data.get(sz - 1)) && Number.validNumber(this.data.get(sz - 2)) && Number.validNumber(this.data.get(sz - 3))) {
            has3NumberArguments = true;
        }
        if (Number.validNumber(this.data.get(sz - 1)) && Number.validNumber(this.data.get(sz - 2)) && !Number.validNumber(this.data.get(sz - 3))) {
            has2NumberArguments = true;
        }
        String function = "";
        if (has2NumberArguments) {
            for (int i = 0; i < sz - 2; ++i) {
                function = function.concat(this.data.get(i));
            }
            NumericalIntegral intg = new NumericalIntegral(Double.valueOf(this.data.get(sz - 2)), Double.valueOf(this.data.get(sz - 1)), 0, function);
            return String.valueOf(intg.findHighRangeIntegral());
        }
        if (has3NumberArguments) {
            for (int i = 0; i < sz - 3; ++i) {
                function = function.concat(this.data.get(i));
            }
            NumericalIntegral intg = new NumericalIntegral(Double.valueOf(this.data.get(sz - 3)), Double.valueOf(this.data.get(sz - 2)), (int)Math.round(Double.parseDouble(this.data.get(sz - 1))), function);
            double val = intg.findHighRangeIntegral();
            return String.valueOf(val);
        }
        return "Function Syntax Error!";
    }

    public double determinant() {
        if (this.data.size() == 1) {
            Function f = FunctionManager.lookUp(this.data.get(0));
            return f.calcDet();
        }
        int size = this.data.size();
        double dimen = Math.sqrt(size);
        if (Math.floor(dimen) == dimen) {
            double[][] arr = new double[(int)dimen][(int)dimen];
            int row = 0;
            int col = 0;
            int dim = (int)dimen;
            for (int i = 0; i < this.data.size(); ++i) {
                arr[row][col] = Double.parseDouble(this.data.get(i));
                if (col == dim - 1) {
                    col = 0;
                    ++row;
                    continue;
                }
                ++col;
            }
            Matrix mat = new Matrix(arr);
            return mat.determinant();
        }
        return Double.NaN;
    }

    public Matrix multiplyMatrix() {
        if (this.data.size() == 2) {
            String token = this.data.get(0);
            String nextToken = this.data.get(1);
            if (Variable.isVariableString(token)) {
                if (Variable.isVariableString(nextToken)) {
                    Function f = FunctionManager.lookUp(token);
                    if (f == null) {
                        return new Matrix("");
                    }
                    Function f1 = FunctionManager.lookUp(nextToken);
                    if (f1 != null) {
                        return Matrix.multiply(f.getMatrix(), f1.getMatrix());
                    }
                    Variable v = VariableManager.lookUp(nextToken);
                    if (v != null) {
                        double val = Double.parseDouble(v.getValue());
                        return f.getMatrix().scalarMultiply(val);
                    }
                } else if (Number.validNumber(nextToken)) {
                    Function f = FunctionManager.lookUp(token);
                    return f.getMatrix().scalarMultiply(Double.parseDouble(nextToken));
                }
            }
        }
        return new Matrix("");
    }

    public Matrix divideMatrix() {
        if (this.data.size() == 2) {
            String token = this.data.get(0);
            String nextToken = this.data.get(1);
            if (Variable.isVariableString(token)) {
                if (Variable.isVariableString(nextToken)) {
                    Function f = FunctionManager.lookUp(token);
                    if (f == null) {
                        return new Matrix("");
                    }
                    Function f1 = FunctionManager.lookUp(nextToken);
                    if (f1 != null) {
                        return Matrix.multiply(f.getMatrix(), f1.getMatrix().inverse());
                    }
                    Variable v = VariableManager.lookUp(nextToken);
                    if (v != null) {
                        double val = Double.parseDouble(v.getValue());
                        return f.getMatrix().scalarDivide(val);
                    }
                } else if (Number.validNumber(nextToken)) {
                    Function f = FunctionManager.lookUp(token);
                    return f.getMatrix().scalarDivide(Double.parseDouble(nextToken));
                }
            }
        }
        return new Matrix("");
    }

    public Matrix addMatrix() {
        if (this.data.size() == 2) {
            String token = this.data.get(0);
            String nextToken = this.data.get(1);
            if (Variable.isVariableString(token) && Variable.isVariableString(nextToken)) {
                Function f = FunctionManager.lookUp(token);
                Function f1 = FunctionManager.lookUp(nextToken);
                if (f != null && f1 != null) {
                    return f.getMatrix().add(f1.getMatrix());
                }
            }
        }
        return new Matrix("");
    }

    public Matrix subtractMatrix() {
        if (this.data.size() == 2) {
            String token = this.data.get(0);
            String nextToken = this.data.get(1);
            if (Variable.isVariableString(token) && Variable.isVariableString(nextToken)) {
                Function f = FunctionManager.lookUp(token);
                Function f1 = FunctionManager.lookUp(nextToken);
                if (f != null && f1 != null) {
                    return f.getMatrix().subtract(f1.getMatrix());
                }
            }
        }
        return new Matrix("");
    }

    public Matrix powerMatrix() {
        if (this.data.size() == 2) {
            String token = this.data.get(0);
            String nextToken = this.data.get(1);
            if (Variable.isVariableString(token) && (Variable.isVariableString(nextToken) || Number.validNumber(nextToken))) {
                double pow;
                Function f = FunctionManager.lookUp(token);
                double d = pow = Variable.isVariableString(nextToken) ? Double.parseDouble(VariableManager.lookUp(nextToken).getValue()) : Double.parseDouble(nextToken);
                if (f != null) {
                    return Matrix.pow(f.getMatrix(), (int)pow);
                }
            }
        }
        throw new InputMismatchException("Bad args for matrix powers");
    }

    public Matrix transpose() {
        Function f;
        String token;
        if (this.data.size() == 1 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            return f.getMatrix().transpose();
        }
        throw new InputMismatchException("Bad args for matrix transpose");
    }

    public Matrix adjoint() {
        Function f;
        String token;
        if (this.data.size() == 1 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            return f.getMatrix().adjoint();
        }
        throw new InputMismatchException("Bad args for matrix adjoint");
    }

    public Matrix cofactorMatrix() {
        Function f;
        String token;
        if (this.data.size() == 1 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            return f.getMatrix().getCofactorMatrix();
        }
        throw new InputMismatchException("Bad args for matrix cofactors");
    }

    public Matrix eigenVectors() {
        Function f;
        String token;
        if (this.data.size() == 1 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            return f.getMatrix().transpose();
        }
        throw new InputMismatchException("Bad args for matrix eigenValues");
    }

    private static final void printImpl(String data) {
        System.out.println("ParserNG> " + data);
    }

    public void print() {
        if (this.data.size() == 1) {
            String token = this.data.get(0);
            if (Variable.isVariableString(token)) {
                Function f = FunctionManager.lookUp(token);
                if (f != null) {
                    switch (f.getType()) {
                        case 1: {
                            Set.printImpl(f.toString());
                            break;
                        }
                        case 2: {
                            Set.printImpl(f.getMatrix().toString());
                            break;
                        }
                        case 3: {
                            Set.printImpl(f.getMatrix().toString());
                            break;
                        }
                        default: {
                            Set.printImpl(f.toString());
                            break;
                        }
                    }
                } else {
                    Variable v = VariableManager.getVariable(token);
                    if (v != null) {
                        Set.printImpl(v.toString());
                    }
                }
            } else if (Number.isNumber(token)) {
                Set.printImpl(token);
            }
            return;
        }
        throw new InputMismatchException("Bad args for printing");
    }

    public String eigenPoly() {
        Function f;
        String token;
        if (this.data.size() == 1 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            return f.getMatrix().getCharacteristicPolynomialForEigenVector();
        }
        throw new InputMismatchException("Bad args for matrix eigenVectors");
    }

    public Matrix editMatrix() {
        Function f;
        String token;
        if (this.data.size() == 4 && Variable.isVariableString(token = this.data.get(0)) && (f = FunctionManager.lookUp(token)) != null) {
            Matrix m = f.getMatrix();
            int row = Integer.parseInt(this.data.get(1));
            int col = Integer.parseInt(this.data.get(2));
            double val = Double.parseDouble(this.data.get(3));
            boolean updated = m.update(val, row, col);
            if (!updated) {
                throw new InputMismatchException("Trying to update outside matrix bounds. Matrix has: " + m.getRows() + " rows and " + m.getCols() + " columns\n But input was: row = " + row + " rows and columns = " + col);
            }
            return m;
        }
        throw new InputMismatchException("Bad args for matrix edit");
    }

    public String evaluateUserDefinedFunction(String operator) throws ClassNotFoundException {
        int sz = this.data.size();
        String fullname = operator.concat("(");
        for (int i = 0; i < sz; ++i) {
            fullname = fullname.concat(this.data.get(i).concat(","));
        }
        fullname = fullname.substring(0, fullname.length() - 1);
        fullname = fullname.concat(")");
        try {
            return FunctionManager.getFunction(operator).evalArgs(fullname);
        }
        catch (Exception cnfe) {
            throw new ClassNotFoundException("Could Not Find Function! " + fullname);
        }
    }
}

