/*
 * Decompiled with CFR 0.152.
 */
package math.quadratic;

import java.util.ArrayList;
import math.quadratic.QuadraticExpressionParser;
import math.quadratic.QuadraticSolver;

public class Quadratic_Equation {
    private QuadraticExpressionParser parser;
    private QuadraticSolver algorithm;

    public Quadratic_Equation(String equation) {
        this.parser = new QuadraticExpressionParser(equation);
        ArrayList<Double> coeffs = this.parser.getCoefficients();
        this.algorithm = new QuadraticSolver(coeffs.get(0), coeffs.get(1), coeffs.get(2));
    }

    public void setParser(QuadraticExpressionParser parser) {
        this.parser = parser;
    }

    public QuadraticExpressionParser getParser() {
        return this.parser;
    }

    public void setAlgorithm(QuadraticSolver algorithm) {
        this.algorithm = algorithm;
    }

    public QuadraticSolver getAlgorithm() {
        return this.algorithm;
    }

    public String interpretedSystem() {
        return this.parser.interpretedSystem();
    }

    public String solutions() {
        return this.algorithm.solve();
    }

    public static void main(String[] args) {
        Quadratic_Equation eqn = new Quadratic_Equation("-2*X^2+3*X+1+X=-9-9X^2");
        System.out.println(eqn.solutions());
    }
}

