/*
 * Decompiled with CFR 0.152.
 */
package math.otherBaseParser;

import java.util.ArrayList;
import math.Maths;
import parser.MathExpression;
import parser.Number;
import parser.Variable;
import parser.methods.Method;

public class BaseNFunction
extends MathExpression {
    private int baseOfOperation;

    public BaseNFunction(String input, int baseOfOperation) {
        super(input);
        this.baseOfOperation = baseOfOperation;
        this.setDRG(1);
        this.convertNumbersToDecimal();
    }

    public void setBaseOfOperation(int baseOfOperation) {
        this.baseOfOperation = baseOfOperation > 1 && baseOfOperation <= 10 ? baseOfOperation : 10;
    }

    public int getBaseOfOperation() {
        return this.baseOfOperation;
    }

    private ArrayList<Integer> isBaseCompatible() {
        ArrayList<String> scanner = this.getScanner();
        ArrayList<Integer> numIndices = new ArrayList<Integer>();
        for (int j = 0; j < scanner.size(); ++j) {
            String mathObject = scanner.get(j);
            String num = "";
            if (!Method.isDefinedMethod(mathObject) && Variable.isVariableString(mathObject)) {
                num = this.getValue(mathObject);
                numIndices.add(j);
            } else if (Number.validNumber(mathObject)) {
                num = mathObject;
                numIndices.add(j);
                for (int i = 0; i < num.length(); ++i) {
                    String val = num.substring(i, i + 1);
                    if (!Character.isDigit(val.toCharArray()[0]) || Integer.valueOf(val) < this.baseOfOperation) continue;
                    this.setCorrectFunction(false);
                    break;
                }
            }
            if (!this.isCorrectFunction()) break;
        }
        return numIndices;
    }

    private void convertNumbersToDecimal() {
        ArrayList<String> scanner = this.getScanner();
        ArrayList<Integer> numIndices = this.isBaseCompatible();
        ArrayList<String> handledVariables = new ArrayList<String>();
        if (this.isCorrectFunction()) {
            for (int i = 0; i < numIndices.size(); ++i) {
                int indexInScanner = numIndices.get(i);
                String mathObject = scanner.get(indexInScanner);
                if (Variable.isVariableString(mathObject) && !handledVariables.contains(mathObject)) {
                    String value = Maths.changeBase(this.getValue(mathObject), "10", String.valueOf(this.baseOfOperation));
                    this.setValue(mathObject, value);
                    handledVariables.add(mathObject);
                    continue;
                }
                if (!Number.validNumber(mathObject)) continue;
                scanner.set(indexInScanner, Maths.num_to_base_10(scanner.get(indexInScanner), String.valueOf(this.baseOfOperation)));
            }
        }
    }

    @Override
    public String solve() {
        if (this.isCorrectFunction()) {
            String val = super.solve();
            if (Number.isNumber(val)) {
                return Maths.changeBase(val, "10", String.valueOf(this.baseOfOperation));
            }
            return val;
        }
        throw new NumberFormatException("Invalid math expression!");
    }

    public static void main(String[] args) {
        BaseNFunction bNFunction = new BaseNFunction("a=10;b=01010;ln(a+b)/cos(a-b)", 2);
        System.out.println(bNFunction.getVariableManager());
        System.out.println(bNFunction.solve());
    }
}

