/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import math.Maths;
import math.matrix.expressParser.MatrixFunction;
import parser.STRING;
import util.FunctionManager;

public class MSet {
    private List<String> data = new ArrayList<String>();

    public MSet(double ... data) {
        for (int i = 0; i < data.length; ++i) {
            this.data.add(data[i] + "");
        }
    }

    public MSet(List<String> data) {
        this.data = data;
    }

    public MSet(MatrixFunction function, List<String> data) {
        System.out.println(data);
        this.data = function.solveSubPortions(data);
    }

    public void setData(ArrayList<String> data) {
        this.data = data;
    }

    public List<String> getData() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public double sum() {
        double u = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u += Double.valueOf(this.data.get(i)).doubleValue();
        }
        return u;
    }

    public double sumOfSquares() {
        double u = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u += Math.pow(Double.valueOf(this.data.get(i)), 2.0);
        }
        return u;
    }

    public double prod() {
        double u = 1.0;
        for (int i = 0; i < this.data.size(); ++i) {
            u *= Double.valueOf(this.data.get(i)).doubleValue();
        }
        return u;
    }

    public double min() {
        double minval = Double.valueOf(this.data.get(0));
        for (int i = 0; i < this.data.size(); ++i) {
            double y = Double.valueOf(this.data.get(i));
            if (!(y < minval)) continue;
            minval = y;
        }
        return minval;
    }

    public double max() {
        double maxval = Double.valueOf(this.data.get(0));
        for (int i = 0; i < this.data.size(); ++i) {
            double y = Double.valueOf(this.data.get(i));
            if (!(y > maxval)) continue;
            maxval = y;
        }
        return maxval;
    }

    public double avg() {
        return this.sum() / (double)this.size();
    }

    public double rms() {
        return Math.sqrt(this.sumOfSquares()) / (double)this.size();
    }

    public double rng() {
        return this.max() - this.min();
    }

    public double mrng() {
        return 0.5 * (this.max() + this.min());
    }

    public double var() {
        double u = 0.0;
        double u1 = 0.0;
        double avrg = this.avg();
        double N = this.size();
        int i = 0;
        while ((double)i < N) {
            u = Double.valueOf(this.data.get(i)) - avrg;
            u1 += Math.pow(u, 2.0);
            ++i;
        }
        return u1 / N;
    }

    public double std_dev() {
        return Math.sqrt(this.var());
    }

    public double std_err() {
        return this.std_dev() / Math.sqrt(this.size());
    }

    public String cov() {
        return 100.0 * this.std_dev() / this.avg() + "%";
    }

    private List<String> displayOuputLineByLine() {
        ArrayList<String> sort = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            sort.add(this.data.get(i));
        }
        return sort;
    }

    public String sort() {
        List<Object> sort = new ArrayList();
        for (int j = 0; j < this.size(); ++j) {
            int i = 0;
            while (i + 1 < this.size()) {
                try {
                    double swapcontrol = 0.0;
                    if (Double.valueOf(this.data.get(i)) > Double.valueOf(this.data.get(i + 1))) {
                        swapcontrol = Double.valueOf(this.data.get(i + 1));
                        this.data.set(i + 1, this.data.get(i));
                        this.data.set(i, String.valueOf(swapcontrol));
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++i;
            }
            if (j != this.size() - 1) continue;
            sort = this.displayOuputLineByLine();
        }
        return STRING.delete(STRING.delete(((Object)sort).toString(), "["), "]");
    }

    public List<String> sort1() {
        List<String> sort = new ArrayList<String>();
        for (int j = 0; j < this.size(); ++j) {
            int i = 0;
            while (i + 1 < this.size()) {
                try {
                    double swapcontrol = 0.0;
                    if (Double.valueOf(this.data.get(i)) > Double.valueOf(this.data.get(i + 1))) {
                        swapcontrol = Double.valueOf(this.data.get(i + 1));
                        this.data.set(i + 1, this.data.get(i));
                        this.data.set(i, String.valueOf(swapcontrol));
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++i;
            }
            if (j != this.size() - 1) continue;
            sort = this.displayOuputLineByLine();
        }
        return sort;
    }

    public double median() {
        double median = 0.0;
        List<Object> scan = new ArrayList();
        scan = this.sort1();
        int g = this.size();
        if (STRING.isEven(g)) {
            double med;
            median = med = (Double.valueOf((String)scan.get(g / 2)) + Double.valueOf((String)scan.get(g / 2 - 1))) / 2.0;
        } else if (!STRING.isEven(g)) {
            median = Double.valueOf((String)scan.get((g - 1) / 2));
        }
        return median;
    }

    public String mode() {
        List<Object> sorter = new ArrayList();
        ArrayList<Double> freq = new ArrayList<Double>();
        sorter = this.sort1();
        int g = sorter.size();
        double count = 0.0;
        for (int j = 0; j < g; ++j) {
            for (int i = 0; i < g; ++i) {
                if (!((String)sorter.get(i)).equals(sorter.get(j))) continue;
                count += 1.0;
            }
            freq.add(count);
            count = 0.0;
        }
        double big = 0.0;
        int index = -1;
        for (int i = 0; i < freq.size(); ++i) {
            if (!(big < (Double)freq.get(i))) continue;
            big = (Double)freq.get(i);
            index = i;
        }
        ArrayList<Object> mode = new ArrayList<Object>();
        for (int i = 0; i < freq.size(); ++i) {
            if ((Double)freq.get(i) != big || mode.contains(sorter.get(i))) continue;
            mode.add(sorter.get(i));
        }
        String dMode = String.valueOf(mode);
        dMode = STRING.delete(STRING.delete(dMode, "["), "]");
        return dMode;
    }

    public List<String> random() {
        ArrayList<String> vals = new ArrayList<String>();
        Random rnd = new Random();
        if (this.size() == 1) {
            int val = Integer.valueOf(this.data.get(0));
            this.data.set(0, String.valueOf(val));
        } else if (this.size() == 2) {
            double val = Double.valueOf(this.data.get(0));
            double val1 = Double.valueOf(this.data.get(1));
            this.data.set(0, String.valueOf((int)val));
            this.data.set(1, String.valueOf((int)val1));
        }
        if (this.size() == 0) {
            vals.add(String.valueOf(rnd.nextFloat()));
        } else if (this.size() == 1) {
            String num = String.valueOf(rnd.nextInt(Integer.valueOf(this.data.get(0))));
            vals.add(num);
        } else if (this.size() == 2) {
            for (int i = 0; i < Integer.valueOf(this.data.get(1)); ++i) {
                vals.add(String.valueOf(rnd.nextInt(Integer.valueOf(this.data.get(0)))));
            }
        } else {
            throw new NoSuchElementException("Allowed Formats For rnd Are rnd(),rnd1(number),rnd1( number1,number2)");
        }
        this.data.clear();
        this.data.addAll(vals);
        return vals;
    }

    public String permutation() {
        String n = this.data.get(0);
        String r = this.data.get(1);
        double n_Factorial = Double.parseDouble(Maths.fact(n));
        double n_Minus_r_Factorial = Double.parseDouble(Maths.fact(String.valueOf(Double.valueOf(n) - Double.valueOf(r))));
        return String.valueOf(n_Factorial / n_Minus_r_Factorial);
    }

    public String combination() {
        String n = this.data.get(0);
        String r = this.data.get(1);
        double n_Factorial = Double.parseDouble(Maths.fact(n));
        double n_Minus_r_Factorial = Double.parseDouble(Maths.fact(String.valueOf(Double.valueOf(n) - Double.valueOf(r))));
        double r_Factorial = Double.parseDouble(Maths.fact(r));
        return String.valueOf(n_Factorial / (n_Minus_r_Factorial * r_Factorial));
    }

    public String power() {
        double n = Double.parseDouble(this.data.get(0));
        double pow = Double.parseDouble(this.data.get(1));
        return String.valueOf(Math.pow(n, pow));
    }

    public String evaluateUserDefinedFunction(String operator) throws ClassNotFoundException {
        int sz = this.data.size();
        System.out.println("operator = " + operator);
        System.out.println("data = " + this.data);
        String fullname = operator.concat("(");
        for (int i = 0; i < sz; ++i) {
            fullname = fullname.concat(this.data.get(i).concat(","));
        }
        fullname = fullname.substring(0, fullname.length() - 1);
        fullname = fullname.concat(")");
        try {
            return FunctionManager.getFunction(operator).evalArgs(fullname);
        }
        catch (Exception cnfe) {
            throw new ClassNotFoundException("Could Not Find Function! " + fullname);
        }
    }

    public static void main(String[] args) {
        MSet set = new MSet(2.0, 3000.0);
        System.out.println(set.permutation());
        System.out.println(set.combination());
        System.out.println(set.random());
    }
}

