/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import math.differentialcalculus.Derivative;
import math.differentialcalculus.Methods;
import math.differentialcalculus.Utilities;
import parser.Number;
import parser.Operator;
import parser.Variable;
import parser.methods.Method;

public class Differentiable {
    private String name;
    private ArrayList<String> data;

    public Differentiable(String name) {
        this.name = name;
        this.data = new ArrayList();
    }

    public Differentiable(String name, ArrayList<String> data) {
        this.name = name;
        this.data = data;
    }

    public boolean isChain() {
        return Utilities.isAutoGenNameFormat(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setData(ArrayList<String> data) {
        this.data = data;
    }

    public ArrayList<String> getData() {
        return this.data;
    }

    public void simplifyDerivedData(ArrayList<String> derivedData) {
        int j;
        int i;
        for (i = 0; i < derivedData.size(); ++i) {
            if (!Operator.isOpeningBracket(derivedData.get(i))) continue;
            j = i + 1;
            while (!Operator.isClosingBracket(derivedData.get(j)) && !Operator.isOpeningBracket(derivedData.get(j))) {
                ++j;
            }
            if (!Operator.isClosingBracket(derivedData.get(j))) continue;
            try {
                if (!Operator.isOpeningBracket(derivedData.get(i - 1)) || !Operator.isClosingBracket(derivedData.get(j + 1))) continue;
                derivedData.remove(j + 1);
                derivedData.remove(i - 1);
                --i;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (i = 0; i < derivedData.size(); ++i) {
            if (!Operator.isOpeningBracket(derivedData.get(i))) continue;
            j = i + 1;
            while (!Operator.isClosingBracket(derivedData.get(j)) && !Operator.isOpeningBracket(derivedData.get(j))) {
                ++j;
            }
            if (!Operator.isClosingBracket(derivedData.get(j))) continue;
            List<String> list = derivedData.subList(i + 1, j);
        }
        for (i = 0; i < derivedData.size(); ++i) {
            String token = derivedData.get(i);
            if (i + 3 < derivedData.size() && (token.equals("+") || token.equals("-") || token.equals("*") || token.equals("/"))) {
                String nextToken = derivedData.get(i + 1);
                String foundToken = derivedData.get(i + 2);
                if (Operator.isOpeningBracket(nextToken) && (Number.isNumber(foundToken) || Variable.isVariableString(foundToken)) && Operator.isClosingBracket(derivedData.get(i + 3))) {
                    List<String> subList = derivedData.subList(i + 1, i + 4);
                    subList.clear();
                    subList.add(foundToken);
                }
            }
            if (i - 1 <= 0 || !token.equals("*") || !Number.isNumber(derivedData.get(i - 1)) || Double.parseDouble(derivedData.get(i - 1)) == 0.0 || Double.parseDouble(derivedData.get(i - 1)) != 1.0) continue;
            derivedData.subList(i - 1, i + 1).clear();
        }
    }

    public ArrayList<String> differentiate(Derivative d) {
        ArrayList<String> derivedData = new ArrayList<String>();
        if (this.data.get(0).equals("(") && this.data.get(1).equals("-") && Variable.isVariableString(this.data.get(2)) && Operator.isClosingBracket(this.data.get(3))) {
            this.data.set(1, "-1");
            this.data.add(2, "*");
        }
        if (this.data.get(0).equals("-") && Variable.isVariableString(this.data.get(1))) {
            this.data.set(0, "-1");
            this.data.add(1, "*");
        }
        boolean autoWrapWithBrackets = false;
        int sz = this.data.size();
        if (sz == 3 && !this.data.get(0).equals("(") && !this.data.get(2).equals(")")) {
            this.data.add(0, "(");
            this.data.add(")");
            autoWrapWithBrackets = true;
            sz = this.data.size();
        } else if (sz == 1) {
            this.data.add(0, "(");
            this.data.add(")");
            sz = this.data.size();
        }
        if (sz == 3) {
            if (Operator.isOpeningBracket(this.data.get(0)) && Variable.isVariableString(this.data.get(1)) && Operator.isClosingBracket(this.data.get(2))) {
                if (d.isBaseVariable(this.data.get(1))) {
                    derivedData.add("1");
                } else if (Utilities.isAutoGenNameFormat(this.data.get(1))) {
                    derivedData.add("diff");
                    derivedData.add("(");
                    derivedData.add(this.data.get(1));
                    derivedData.add(")");
                }
            } else if (Operator.isOpeningBracket(this.data.get(0)) && Number.isNumber(this.data.get(1)) && Operator.isClosingBracket(this.data.get(2))) {
                derivedData.add("0");
            }
        } else if (sz == 4) {
            if (Method.isMethodName(this.data.get(0)) && Operator.isOpeningBracket(this.data.get(1)) && Variable.isVariableString(this.data.get(2)) && Operator.isClosingBracket(this.data.get(3))) {
                derivedData.addAll(Methods.getMethodDifferential(this.data.get(0), this.data.get(2), d));
            }
        } else if (sz == 5) {
            if (Method.isMethodName(this.data.get(0)) && Operator.isOpeningBracket(this.data.get(1)) && this.data.get(2).equals("-") && Variable.isVariableString(this.data.get(3)) && Operator.isClosingBracket(this.data.get(4))) {
                derivedData.add("-1");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.addAll(Methods.getMethodDifferential(this.data.get(0), this.data.get(3), d));
                derivedData.add(")");
            } else if (Number.isNumber(this.data.get(1)) && Operator.isPower(this.data.get(2)) && Number.isNumber(this.data.get(3))) {
                derivedData.add("0");
            } else if (Number.isNumber(this.data.get(1)) && Operator.isPower(this.data.get(2)) && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(this.data.get(2));
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("ln");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && Operator.isPower(this.data.get(2)) && Number.isNumber(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add("^");
                derivedData.add("" + (Double.parseDouble(this.data.get(3)) - 1.0));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && Operator.isPower(this.data.get(2)) && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(this.data.get(2));
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("ln");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("+");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("/");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add(")");
                derivedData.add(")");
            } else if (Number.isNumber(this.data.get(1)) && this.data.get(2).equals("*") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("*") && Number.isNumber(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("*") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("+");
                derivedData.add(this.data.get(1));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Number.isNumber(this.data.get(1)) && this.data.get(2).equals("/") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("" + -1.0 * Double.parseDouble(this.data.get(1)));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("^");
                derivedData.add("-2");
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("/") && Number.isNumber(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("/");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("/") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("^");
                derivedData.add("-1");
                derivedData.add(")");
                derivedData.add("-");
                derivedData.add(this.data.get(1));
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add("*");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add("^");
                derivedData.add("-2");
                derivedData.add(")");
                derivedData.add(")");
            } else if (Number.isNumber(this.data.get(1)) && this.data.get(2).equals("+") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("+") && Number.isNumber(this.data.get(3))) {
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("+") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("+");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Number.isNumber(this.data.get(1)) && this.data.get(2).equals("-") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("-1");
                derivedData.add("*");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("-") && Number.isNumber(this.data.get(3))) {
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
            } else if (Variable.isVariableString(this.data.get(1)) && this.data.get(2).equals("-") && Variable.isVariableString(this.data.get(3))) {
                derivedData.add("(");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(1));
                derivedData.add(")");
                derivedData.add("-");
                derivedData.add("diff");
                derivedData.add("(");
                derivedData.add(this.data.get(3));
                derivedData.add(")");
                derivedData.add(")");
            }
        }
        for (int i = 0; i < derivedData.size(); ++i) {
            try {
                List<String> temp;
                List<String> temp2;
                ArrayList<String> derived;
                Differentiable diff;
                if (((String)derivedData.get(i)).equals("diff") && Operator.isOpeningBracket((String)derivedData.get(i + 1)) && Variable.isVariableString((String)derivedData.get(i + 2)) && Operator.isClosingBracket((String)derivedData.get(i + 3))) {
                    if (Utilities.isAutoGenNameFormat(derivedData.get(i + 2))) {
                        diff = d.builder.getManager().lookUp(derivedData.get(i + 2));
                        derived = diff.differentiate(d);
                        temp2 = derivedData.subList(i, i + 4);
                        temp2.clear();
                        temp2.addAll(derived);
                        --i;
                        continue;
                    }
                    if (!d.isBaseVariable(derivedData.get(i + 2))) continue;
                    temp = derivedData.subList(i, i + 4);
                    temp.clear();
                    temp.add("1");
                    continue;
                }
                if (!((String)derivedData.get(i)).equals("diff") || !Operator.isOpeningBracket((String)derivedData.get(i + 1)) || !((String)derivedData.get(i + 2)).equals("-") || !Variable.isVariableString(derivedData.get(i + 3)) || !Operator.isClosingBracket(derivedData.get(i + 4))) continue;
                if (Utilities.isAutoGenNameFormat(derivedData.get(i + 3))) {
                    diff = d.builder.getManager().lookUp(derivedData.get(i + 2));
                    derived = diff.differentiate(d);
                    temp2 = derivedData.subList(i, i + 4);
                    temp2.clear();
                    temp2.add("-1");
                    temp2.add("*");
                    temp2.add("(");
                    temp2.addAll(derived);
                    temp2.add(")");
                    --i;
                    continue;
                }
                if (!d.isBaseVariable(derivedData.get(i + 3))) continue;
                temp = derivedData.subList(i, i + 4);
                temp.clear();
                temp.add("-1");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (autoWrapWithBrackets && this.data.get(0).equals("(") && this.data.get(this.data.size() - 1).equals(")")) {
            this.data.remove(this.data.size() - 1);
            this.data.remove(0);
            autoWrapWithBrackets = false;
        }
        if ((this.data.contains("+") || this.data.contains("-")) && !this.data.get(0).equals("(") && !this.data.get(this.data.size() - 1).equals(")")) {
            this.data.add(0, "(");
            this.data.add(")");
        }
        if ((derivedData.contains("+") || derivedData.contains("-")) && !((String)derivedData.get(0)).equals("(") && !((String)derivedData.get(derivedData.size() - 1)).equals(")")) {
            derivedData.add(0, "(");
            derivedData.add(")");
        }
        Utilities.print("data---" + this.data + "---Diff of data = derivedData---" + derivedData);
        return derivedData;
    }

    public String getDerivativeExpression(ArrayList<String> derivedData) {
        return Utilities.getText(derivedData);
    }

    public String getExpression() {
        return Utilities.getText(this.data);
    }
}

