/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import parser.MathExpression;
import parser.Number;
import util.Utils;

public class PolynomialExpression
extends MathExpression {
    public static final int DOUBLE_PRECISION = 1;
    public static final int BIGDECIMAL_PRECISION = 2;
    private int precision = 1;

    public PolynomialExpression(String expression, int precision) {
        super(expression);
        this.setPrecision(precision);
        if (this.isHasLogicOperators() || this.isHasListReturningOperators() || this.isHasPreNumberOperators() || this.isHasNumberReturningStatsOperators() || this.isHasPermOrCombOperators() || this.isHasRemainderOperators() || this.isHasPostNumberOperators()) {
            this.setCorrectFunction(false);
            Utils.logError("Only Polynomial Expressions Treated Here!");
        }
    }

    public void setPrecision(int precision) {
        this.precision = precision == 1 ? 1 : (precision == 2 ? 2 : 1);
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public List<String> solve(List<String> list) {
        if (this.precision == 1) {
            return this.doublePrecisionSolve(list);
        }
        if (this.precision == 2) {
            return this.bigDecimalPrecisionSolve(list);
        }
        throw new InputMismatchException(" Select A Valid Precision");
    }

    public List<String> doublePrecisionSolve(List<String> list) {
        if (list.get(0).equals("(") && list.get(1).equals("-") && Number.isNumber(list.get(2))) {
            list.set(1, "");
            if (list.get(2).substring(0, 1).equals("-")) {
                list.set(2, list.get(2).substring(1));
            } else {
                list.set(2, "-" + list.get(2));
            }
        }
        ArrayList<String> real = new ArrayList<String>();
        real.add("");
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (this.isHasPowerOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i - 1)), Double.valueOf(list.get(i + 1)))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        list.removeAll(real);
        boolean skip = false;
        if (this.isHasMulOrDivOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (list.get(i).equals("*")) {
                        if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, String.valueOf(Double.valueOf(list.get(i - 1)) * Double.valueOf(list.get(i + 1))));
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i).equals("/")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, String.valueOf(Double.valueOf(list.get(i - 1)) / Double.valueOf(list.get(i + 1))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    skip = true;
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (this.isHasPlusOrMinusOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i).equals("+") && !list.get(i).equals("-")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (list.get(i).equals("+") && Number.isNumber(list.get(i - 1)) && Number.isNumber(list.get(i + 1))) {
                            list.set(i + 1, String.valueOf(Double.valueOf(list.get(i - 1)) + Double.valueOf(list.get(i + 1))));
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("-") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Double.valueOf(list.get(i - 1)) - Double.valueOf(list.get(i + 1))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (list.size() != 1) {
            this.correctFunction = false;
        }
        return list;
    }

    public List<String> bigDecimalPrecisionSolve(List<String> list) {
        BigDecimal rhs;
        BigDecimal lhs;
        if (list.get(0).equals("(") && list.get(1).equals("-") && Number.isNumber(list.get(2))) {
            list.set(1, "");
            if (list.get(2).substring(0, 1).equals("-")) {
                list.set(2, list.get(2).substring(1));
            } else {
                list.set(2, "-" + list.get(2));
            }
        }
        ArrayList<String> real = new ArrayList<String>();
        real.add("");
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (this.isHasPowerOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        BigDecimal lhs2 = new BigDecimal(list.get(i - 1));
                        String rhs2 = list.get(i + 1);
                        list.set(i + 1, String.valueOf(lhs2.pow(Integer.valueOf(rhs2), MathContext.DECIMAL128)));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException lhs2) {
                    continue;
                }
                catch (NullPointerException lhs2) {
                    continue;
                }
                catch (IndexOutOfBoundsException lhs2) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        list.removeAll(real);
        boolean skip = false;
        if (this.isHasMulOrDivOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (list.get(i).equals("*")) {
                        if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            lhs = new BigDecimal(list.get(i - 1));
                            rhs = new BigDecimal(list.get(i + 1));
                            list.set(i + 1, String.valueOf(lhs.multiply(rhs, MathContext.DECIMAL128)));
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            skip = true;
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i).equals("/")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        lhs = new BigDecimal(list.get(i - 1));
                        rhs = new BigDecimal(list.get(i + 1));
                        list.set(i + 1, String.valueOf(lhs.divide(rhs, MathContext.DECIMAL128)));
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        skip = true;
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    skip = true;
                    continue;
                }
                catch (NullPointerException lhs3) {
                    continue;
                }
                catch (NumberFormatException lhs3) {
                    continue;
                }
                catch (IndexOutOfBoundsException lhs3) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (this.isHasPlusOrMinusOperators()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i).equals("+") && !list.get(i).equals("-")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (list.get(i).equals("+") && Number.isNumber(list.get(i - 1)) && Number.isNumber(list.get(i + 1))) {
                            lhs = new BigDecimal(list.get(i - 1));
                            rhs = new BigDecimal(list.get(i + 1));
                            list.set(i + 1, String.valueOf(lhs.add(rhs, MathContext.DECIMAL128)));
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("-") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        lhs = new BigDecimal(list.get(i - 1));
                        rhs = new BigDecimal(list.get(i + 1));
                        list.set(i + 1, String.valueOf(lhs.subtract(rhs, MathContext.DECIMAL128)));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (list.size() != 1) {
            this.correctFunction = false;
        }
        return list;
    }

    public static void main(String[] args) {
        String expr = "var x=2;8x/3";
        PolynomialExpression polyExpression = new PolynomialExpression(expr, 2);
        System.out.println(polyExpression.solve());
    }
}

