/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import parser.BinaryOperator;
import parser.LogicOperator;
import parser.MathExpression;
import parser.Precedence;
import parser.UnaryPostOperator;
import parser.UnaryPreOperator;

public class Operator {
    private String name;
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String DIVIDE = "/";
    public static final String MULTIPLY = "*";
    public static final String EN_DASH = "\u2013";
    public static final String FACTORIAL = "!";
    public static final String POWER = "^";
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String ASSIGN = "=";
    public static final String EQUALS = "==";
    public static final String LESS_OR_EQUALS = "\u2264";
    public static final String GREATER_OR_EQUALS = "\u2265";
    public static final String AND = "&";
    public static final String OR = "|";
    public static final String REMAINDER = "%";
    public static final String OPEN_CIRC_BRAC = "(";
    public static final String CLOSE_CIRC_BRAC = ")";
    public static final String COMMA = ",";
    public static final String ROOT = "\u221a";
    public static final String CUBE_ROOT = "\u00b3\u221a";
    public static final String PERMUTATION = "\u0420";
    public static final String COMBINATION = "\u010c";
    public static final String INVERSE = "-\u00b9";
    public static final String SQUARE = "\u00b2";
    public static final String CUBE = "\u00b3";
    public static final String OPEN_SQUARE_BRAC = "[";
    public static final String CLOSE_SQUARE_BRAC = "]";
    public static final String COLON = ":";
    public static final String CONST = "const";
    public static final String STORE = "store:";
    public static final String EXIT = "exit:";
    public static final String SPACE = " ";
    public static final String SEMI_COLON = ";";
    public static final String AT = "@";
    public static final String[] operators = new String[]{"+", "-", "/", "*", "!", "^", "<", ">", "=", "==", "\u2264", "\u2265", "&", "|", "%", "(", ")", ",", "\u221a", "\u00b3\u221a", "\u0420", "\u010c", "-\u00b9", "\u00b2", "\u00b3", "[", "]", ":", "const", "store:", "exit:", " ", ";", "@"};

    public Operator(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isOperatorString(String op) {
        return op.equals(PLUS) || op.equals(MINUS) || op.equals(DIVIDE) || op.equals(MULTIPLY) || op.equals(FACTORIAL) || op.equals(POWER) || op.equals(LESS_THAN) || op.equals(GREATER_THAN) || op.equals(ASSIGN) || op.equals(EQUALS) || op.equals(GREATER_OR_EQUALS) || op.equals(LESS_OR_EQUALS) || op.equals(AND) || op.equals(OR) || op.equals(REMAINDER) || op.equals(OPEN_CIRC_BRAC) || op.equals(CLOSE_CIRC_BRAC) || op.equals(ROOT) || op.equals(CUBE_ROOT) || op.equals(COMBINATION) || op.equals(PERMUTATION) || op.equals(INVERSE) || op.equals(SQUARE) || op.equals(CUBE) || op.equals(COMMA) || op.equals(OPEN_SQUARE_BRAC) || op.equals(CLOSE_SQUARE_BRAC) || op.equals(COLON) || op.equals(CONST) || op.equals(STORE) || op.equals(EXIT) || op.equals(SPACE) || op.equals(SEMI_COLON) || op.equals(AT);
    }

    public static boolean isExitCommand(String op) {
        return op.equals(EXIT);
    }

    public boolean isSemiColon(String op) {
        return op.equals(SEMI_COLON);
    }

    public static boolean isAtOperator(String op) {
        return op.equals(AT);
    }

    public static boolean isStoreCommand(String op) {
        return op.equals(STORE);
    }

    public static boolean isConstantStoreCommand(String op) {
        return op.equals(CONST);
    }

    public static boolean isOpeningBrace(String op) {
        return op.equals(OPEN_SQUARE_BRAC);
    }

    public static boolean isClosingBrace(String op) {
        return op.equals(CLOSE_SQUARE_BRAC);
    }

    public static boolean isColon(String op) {
        return op.equals(COLON);
    }

    public static boolean isLogicOperator(String op) {
        return op.equals(EQUALS) || op.equals(LESS_OR_EQUALS) || op.equals(GREATER_OR_EQUALS) || op.equals(LESS_THAN) || op.equals(GREATER_THAN) || op.equals(OR) || op.equals(AND);
    }

    public static boolean isEqualsOperator(String op) {
        return op.equals(EQUALS);
    }

    public static boolean isAssignmentOperator(String op) {
        return op.equals(ASSIGN);
    }

    public static boolean isBinaryOperator(String op) {
        return op.equals(PLUS) || op.equals(MINUS) || op.equals(DIVIDE) || op.equals(MULTIPLY) || op.equals(POWER) || op.equals(REMAINDER) || op.equals(COMBINATION) || op.equals(PERMUTATION);
    }

    public static boolean isPlusOrMinus(String op) {
        return op.equals(PLUS) || op.equals(MINUS);
    }

    public static boolean isMulOrDiv(String op) {
        return op.equals(DIVIDE) || op.equals(MULTIPLY);
    }

    public static boolean isPermOrComb(String op) {
        return op.equals(COMBINATION) || op.equals(PERMUTATION);
    }

    public static boolean isMulOrDivOrRemOrPermOrCombOrPow(String op) {
        return Operator.isBinaryOperator(op) && !Operator.isPlusOrMinus(op);
    }

    public static boolean isRemainder(String op) {
        return op.equals(REMAINDER);
    }

    public static boolean isPower(String op) {
        return op.equals(POWER);
    }

    public static boolean isBracket(String op) {
        return op.equals(OPEN_CIRC_BRAC) || op.equals(CLOSE_CIRC_BRAC);
    }

    public static boolean isOpeningBracket(String op) {
        return op.equals(OPEN_CIRC_BRAC);
    }

    public static boolean isClosingBracket(String op) {
        return op.equals(CLOSE_CIRC_BRAC);
    }

    public static boolean isFactorial(String op) {
        return op.equals(FACTORIAL);
    }

    public static boolean isInverse(String op) {
        return op.equals(INVERSE);
    }

    public static boolean isSquareRoot(String op) {
        return op.equals(ROOT);
    }

    public static boolean isCubeRoot(String op) {
        return op.equals(CUBE_ROOT);
    }

    public static boolean isSquare(String op) {
        return op.equals(SQUARE);
    }

    public static boolean isCube(String op) {
        return op.equals(CUBE);
    }

    public static boolean isUnaryPreOperator(String op) {
        return op.equals(ROOT) || op.equals(CUBE_ROOT);
    }

    public static boolean isUnaryPostOperator(String op) {
        return op.equals(INVERSE) || op.equals(FACTORIAL) || op.equals(SQUARE) || op.equals(CUBE);
    }

    public static boolean isComma(String op) {
        return op.equals(COMMA);
    }

    public static Precedence getPrecedence(String name) {
        if (Operator.isUnaryPostOperator(name)) {
            return new Precedence(10000);
        }
        if (Operator.isPower(name)) {
            return new Precedence(9999);
        }
        if (Operator.isUnaryPreOperator(name)) {
            return new Precedence(9998);
        }
        if (Operator.isMulOrDiv(name)) {
            return new Precedence(9997);
        }
        if (Operator.isRemainder(name)) {
            return new Precedence(9996);
        }
        if (Operator.isPlusOrMinus(name)) {
            return new Precedence(9995);
        }
        return null;
    }

    public static void orderCompoundTokens(MathExpression function) {
        ArrayList<String> scanner = function.getScanner();
        for (int i = 0; i < scanner.size(); ++i) {
            if (!Operator.isPower(scanner.get(i))) continue;
        }
    }

    public static boolean validateAll(ArrayList<String> scan) {
        boolean correct = true;
        for (int i = 0; i < scan.size(); ++i) {
            if (Operator.isBinaryOperator(scan.get(i))) {
                correct = new BinaryOperator(scan.get(i), i, scan).validate(scan);
                continue;
            }
            if (Operator.isLogicOperator(scan.get(i))) {
                correct = new LogicOperator(scan.get(i), i, scan).validate(scan);
                continue;
            }
            if (Operator.isUnaryPostOperator(scan.get(i))) {
                correct = new UnaryPostOperator(scan.get(i), i, scan).validate(scan);
                continue;
            }
            if (!Operator.isUnaryPreOperator(scan.get(i))) continue;
            correct = new UnaryPreOperator(scan.get(i), i, scan).validate(scan);
        }
        return correct;
    }
}

