/*
 * Decompiled with CFR 0.152.
 */
package math.numericalmethods;

import java.util.InputMismatchException;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.Derivative;
import math.numericalmethods.FunctionExpander;
import parser.Function;
import parser.MathExpression;
import parser.Variable;
import util.FunctionManager;

public class NumericalDerivative {
    private Function function;
    private double xPoint;

    public NumericalDerivative() {
    }

    public NumericalDerivative(String expression) {
        new Parser(expression);
    }

    public NumericalDerivative(Function function, double xPoint) {
        this.function = function;
        this.xPoint = xPoint;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setxPoint(double xPoint) {
        this.xPoint = xPoint;
    }

    public double getxPoint() {
        return this.xPoint;
    }

    public String findDerivativeByPolynomialExpander() {
        FunctionExpander expander = new FunctionExpander(this.xPoint - 1.0E-4, this.xPoint + 0.1, 20, 1, this.function);
        MathExpression polyDerivative = new MathExpression(expander.getPolynomialDerivative());
        polyDerivative.setDRG(1);
        String variable = this.function.getIndependentVariables().get(0).getName();
        polyDerivative.setValue(variable, String.valueOf(this.xPoint));
        return polyDerivative.solve();
    }

    public String findDerivativeByLimit(double dx) {
        MathExpression func = this.function.getMathExpression();
        func.setDRG(1);
        func.setValue(this.function.getIndependentVariables().get(0).getName(), String.valueOf(this.xPoint + dx));
        String upper = func.solve();
        func.setValue(this.function.getIndependentVariables().get(0).getName(), String.valueOf(this.xPoint - dx));
        String lower = func.solve();
        double derived = (Double.parseDouble(upper) - Double.parseDouble(lower)) / (2.0 * dx);
        return String.valueOf(derived);
    }

    public static Object[] extractFunctionStringFromExpression(String expression) {
        if ((expression = expression.trim()).startsWith("diff(") && expression.endsWith(")")) {
            try {
                expression = expression.substring(0, expression.length() - 1);
                expression = expression.substring(expression.indexOf("(") + 1);
                double xPoint = Double.parseDouble(new MathExpression(expression.substring(expression.lastIndexOf(",") + 1).trim()).solve());
                String func = expression.substring(0, expression.lastIndexOf(",")).trim();
                try {
                    if (func.startsWith("@")) {
                        return new Object[]{func, xPoint};
                    }
                    if (Variable.isVariableString(func)) {
                        return new Object[]{func, xPoint};
                    }
                    throw new InputMismatchException("ALGEBRAIC_EXPRESSION SYNTAX ERROR");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
            }
            catch (NumberFormatException formatException) {
                throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
            }
            catch (IndexOutOfBoundsException indException) {
                throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
            }
            catch (NullPointerException exception) {
                throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
            }
        } else {
            throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
        }
        throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
    }

    public static void main(String[] args) {
        double evalPoint = 3.2;
        FunctionManager.add("F=@(x)sin(x)/(x^3)*sin(x)");
        FunctionManager.add("P=@(x)ln(x)");
        NumericalDerivative der = new NumericalDerivative(FunctionManager.lookUp("F"), evalPoint);
        System.out.println("expression = " + der.function.getMathExpression().getExpression());
        System.out.println("dependent variable = " + der.function.getDependentVariable());
        System.out.println("independent variable = " + der.function.getIndependentVariables());
        System.out.println("Derivative by polynomial expander approx: " + der.findDerivativeByPolynomialExpander());
        System.out.println("Derivative by limit approx: " + der.findDerivativeByLimit(2.0E-6));
        try {
            String expr = Derivative.eval("diff(F," + evalPoint + ")");
            System.out.println("Absolute derivative: " + expr);
        }
        catch (Exception ex) {
            Logger.getLogger(NumericalDerivative.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getVariable() {
        return this.function.getIndependentVariables().get(0).getName();
    }

    public class Parser {
        public Parser(String expression) {
            NumericalDerivative.this.setFunction(this.parseDerivativeCommand(expression));
        }

        public Function parseDerivativeCommand(String expression) {
            if ((expression = expression.trim()).startsWith("diff(") && expression.endsWith(")")) {
                try {
                    expression = expression.substring(0, expression.length() - 1);
                    expression = expression.substring(expression.indexOf("(") + 1);
                    double xPoint = Double.parseDouble(expression.substring(expression.lastIndexOf(",") + 1).trim());
                    String func = expression.substring(0, expression.lastIndexOf(",")).trim();
                    NumericalDerivative.this.setxPoint(xPoint);
                    try {
                        if (func.startsWith("@")) {
                            return new Function(func);
                        }
                        if (Variable.isVariableString(func)) {
                            return FunctionManager.lookUp(func);
                        }
                        throw new InputMismatchException("ALGEBRAIC_EXPRESSION SYNTAX ERROR");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                }
                catch (NumberFormatException formatException) {
                    throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
                }
                catch (IndexOutOfBoundsException indException) {
                    throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
                }
                catch (NullPointerException exception) {
                    throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
                }
            } else {
                throw new InputMismatchException("SYNTAX ERROR! CHECK THE HELP FILE FOR THE VALID COMMAND TO USE NEAR \"diff\"");
            }
            throw new InputMismatchException("INVALID ALGEBRAIC_EXPRESSION");
        }
    }
}

