/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.Arrays;
import java.util.List;
import parser.Bracket;
import parser.DataSetFormatter;
import parser.Function;
import parser.LISTS;
import parser.MathExpression;
import parser.MathScanner;
import parser.Number;
import parser.Operator;
import parser.Parser_Result;
import parser.Variable;
import util.FunctionManager;
import util.VariableManager;

public class Parser {
    private double evalPoint = Double.POSITIVE_INFINITY;
    private Function function;
    private int orderOfDifferentiation = Integer.MAX_VALUE;
    public Parser_Result result = Parser_Result.VALID;
    private int diffType = 2;
    public static final int GRAD_FUNC = 1;
    public static final int GRAD_VAL = 2;

    public Parser(String expression) {
        DataSetFormatter dsf = new DataSetFormatter(expression);
        List<String> scanner = dsf.getDataset();
        MathScanner.recognizeAnonymousFunctions(scanner);
        this.function = this.localParseDerivativeCommand(scanner);
    }

    public double getEvalPoint() {
        return this.evalPoint;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getOrderOfDifferentiation() {
        return this.orderOfDifferentiation;
    }

    public void setOrderOfDifferentiation(int orderOfDifferentiation) {
        this.orderOfDifferentiation = orderOfDifferentiation;
    }

    public int getDiffType() {
        return this.diffType;
    }

    public void setDiffType(int diffType) {
        this.diffType = diffType;
    }

    public boolean isGradFunc() {
        return this.diffType == 1;
    }

    public boolean isGradEval() {
        return this.diffType == 2;
    }

    private Function localParseDerivativeCommand(List<String> list) {
        list.removeAll(Arrays.asList(","));
        String args2 = "";
        if (list.get(0).equals("diff") && list.get(1).equals("(") && list.get(list.size() - 1).equals(")")) {
            String args1;
            boolean exists;
            String functionName = list.get(2);
            if (Variable.isVariableString(functionName) && (exists = FunctionManager.contains(functionName))) {
                for (int i = 3; i < list.size(); ++i) {
                    if (Operator.isOpeningBracket(list.get(i))) {
                        int closeBracket = Bracket.getComplementIndex(true, i, list);
                        args1 = new MathExpression(LISTS.createStringFrom(list, i, closeBracket + 1)).solve();
                        List<String> l = list.subList(i, closeBracket + 1);
                        l.clear();
                        l.add(args1);
                        continue;
                    }
                    if (!Variable.isVariableString(list.get(i))) continue;
                    String val = VariableManager.getVariable(list.get(i)).getValue();
                    list.set(i, val);
                }
            }
            if (Bracket.isCloseBracket(args1 = list.get(3))) {
                this.diffType = 1;
                this.orderOfDifferentiation = 1;
            } else if (Number.validNumber(args1)) {
                args2 = list.get(4);
                if (Number.validNumber(args2)) {
                    this.diffType = 2;
                    this.evalPoint = Double.parseDouble(args1);
                    this.orderOfDifferentiation = (int)Double.parseDouble(args2);
                } else {
                    this.diffType = 1;
                    this.orderOfDifferentiation = (int)Double.parseDouble(args1);
                }
            }
            return FunctionManager.lookUp(functionName);
        }
        return null;
    }

    public static void parseDerivativeCommand(List<String> list) {
        list.removeAll(Arrays.asList(","));
        String args2 = "";
        if (list.get(0).equals("diff") && list.get(1).equals("(") && list.get(list.size() - 1).equals(")")) {
            String args1;
            boolean exists;
            String functionName = list.get(2);
            if (Variable.isVariableString(functionName) && (exists = FunctionManager.contains(functionName))) {
                for (int i = 3; i < list.size(); ++i) {
                    if (Operator.isOpeningBracket(list.get(i))) {
                        int closeBracket = Bracket.getComplementIndex(true, i, list);
                        args1 = new MathExpression(LISTS.createStringFrom(list, i, closeBracket + 1)).solve();
                        List<String> l = list.subList(i, closeBracket + 1);
                        l.clear();
                        l.add(args1);
                        continue;
                    }
                    if (!Variable.isVariableString(list.get(i))) continue;
                    String val = VariableManager.getVariable(list.get(i)).getValue();
                    list.set(i, val);
                }
            }
            int sz = list.size();
            switch (sz) {
                case 4: {
                    break;
                }
                case 5: {
                    args1 = list.get(3);
                    break;
                }
                case 6: {
                    args1 = list.get(3);
                    args2 = list.get(4);
                    break;
                }
                default: {
                    list.clear();
                }
            }
        }
    }

    public static void main(String[] args) {
        FunctionManager.add(new Function("F(x)=sin(x)"));
        Parser p = new Parser("diff(F,2,5)");
        System.err.println("-----func: " + p.function);
        System.err.println("-----evalPoint: " + p.evalPoint);
        System.err.println("-----order: " + p.orderOfDifferentiation);
    }
}

