/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.CodeGenerator;
import math.differentialcalculus.DerivativeStructureBuilder;
import math.differentialcalculus.Differentiable;
import math.differentialcalculus.Parser;
import math.differentialcalculus.Utilities;
import parser.MathExpression;
import parser.Number;
import parser.Parser_Result;
import parser.Variable;

public class Derivative {
    private String mathExpr;
    public DerivativeStructureBuilder builder;

    Derivative(String expression) throws Exception {
        this.mathExpr = Utilities.isAutoGenNameFormat(expression) ? this.builder.getManager().lookUp(expression).getExpression() : expression;
        this.builder = new DerivativeStructureBuilder(this.mathExpr);
    }

    public void setMathExpr(String mathExpr) {
        this.mathExpr = mathExpr;
    }

    public String getMathExpr() {
        return this.mathExpr;
    }

    public ArrayList<String> translateToBaseTerms(Differentiable d) {
        ArrayList<String> data = new ArrayList<String>(d.getData());
        Utilities.print("Expanding " + d.getName() + "---expression list is---" + d.getData());
        for (int i = 0; i < data.size(); ++i) {
            if (!Utilities.isAutoGenNameFormat(data.get(i))) continue;
            String name = data.get(i);
            ArrayList<String> temp = this.builder.getManager().lookUp(name).getData();
            Utilities.print("found----diff variable---" + data.get(i) + "--internal data is---" + temp);
            List<String> subList = data.subList(i, i + 1);
            subList.clear();
            subList.addAll(temp);
            --i;
            Utilities.print("Expansion gives------" + d.getData());
        }
        return data;
    }

    public ArrayList<String> translateToBaseTerms_1(Differentiable d) {
        ArrayList<String> data = new ArrayList<String>(d.getData());
        for (int i = 0; i < data.size(); ++i) {
            if (!Utilities.isAutoGenNameFormat(data.get(i))) continue;
            String name = data.get(i);
            ArrayList<String> temp = this.builder.getManager().lookUp(name).getData();
            data.remove(i);
            data.addAll(i, temp);
            Utilities.print("temp---" + temp);
        }
        return data;
    }

    public String differentiate() {
        ArrayList<String> array = this.differentiateAsList();
        StringBuilder build = new StringBuilder("");
        for (String str : array) {
            build.append(str);
        }
        return build.toString();
    }

    public ArrayList<String> differentiateAsList() {
        int i;
        Differentiable root = this.builder.getManager().lastDifferentiable();
        Utilities.print("Here is the chain---" + this.builder.getManager().getDIFFERENTIABLES());
        Utilities.print("root---" + root);
        ArrayList<String> array = root.differentiate(this);
        Utilities.print("diff array---" + array);
        for (i = 0; i < array.size(); ++i) {
            try {
                if (!Utilities.isAutoGenNameFormat(array.get(i))) continue;
                Differentiable d = this.builder.getManager().lookUp(array.get(i));
                ArrayList<String> data = this.translateToBaseTerms(d);
                array.remove(i);
                array.addAll(i, data);
                i -= 2;
                continue;
            }
            catch (IndexOutOfBoundsException d) {
                // empty catch block
            }
        }
        Utilities.print("list size before optimizing = " + array.size());
        root.simplifyDerivedData(array);
        Utilities.print("list size after optimizing = " + array.size());
        for (i = 0; i < array.size(); ++i) {
            try {
                if (Variable.isVariableString(array.get(i)) && array.get(i + 1).equals("^") && Number.isNumber(array.get(i + 2)) && Double.parseDouble(array.get(i + 2)) == 1.0) {
                    List<String> temp = array.subList(i + 1, i + 3);
                    temp.clear();
                    --i;
                }
                CodeGenerator.openUpUnnecessaryBrackets(array);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return array;
    }

    public static String eval(String expr) {
        try {
            Parser p = new Parser(expr);
            if (p.result == Parser_Result.VALID) {
                expr = "diff(" + p.getFunction().getMathExpression().getExpression() + ")";
                int orderOfDiff = p.getOrderOfDifferentiation();
                if (p.isGradEval()) {
                    double evalPoint = p.getEvalPoint();
                    for (int i = 1; i <= orderOfDiff; ++i) {
                        Derivative derivative = new Derivative(expr);
                        expr = "diff(" + derivative.differentiate() + ")";
                    }
                    expr = expr.substring(5, expr.length() - 1);
                    MathExpression me = new MathExpression("x=" + evalPoint + ";" + expr);
                    return me.solve();
                }
                for (int i = 1; i <= orderOfDiff; ++i) {
                    Derivative derivative = new Derivative(expr);
                    expr = "diff(" + derivative.differentiate() + ")";
                }
                expr = expr.substring(5, expr.length() - 1);
                return expr;
            }
            return "Input Error";
        }
        catch (Exception e) {
            return "Input Error";
        }
    }

    public static void main(String[] args) {
        try {
            String expression = "diff(@(x)4*x*x*sin(x^2)-x,3,1)";
            System.out.println(Derivative.eval(expression));
        }
        catch (Exception ex) {
            Logger.getLogger(DerivativeStructureBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

