/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import parser.STRING;

public class Maths {
    public static BigDecimal PI = new BigDecimal("3.14159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651");

    public static String PI() {
        return "3.1415926535897932";
    }

    public static String fact(String p) {
        double dbVal;
        String fact5 = "";
        double i = 1.0;
        double prod = 1.0;
        double fact = 0.0;
        double n = Math.floor(dbVal);
        double k = dbVal - n;
        double d = 160.0 + k;
        if (dbVal == 0.0 || dbVal == 1.0) {
            fact = 1.0;
        } else if (dbVal < 0.0 && k == 0.0) {
            fact = Double.NEGATIVE_INFINITY;
        } else if (dbVal <= d && k == 0.0) {
            for (dbVal = Double.parseDouble(p); dbVal > 0.0; dbVal -= 1.0) {
                prod *= dbVal;
            }
            fact = prod;
        } else if (dbVal <= d && k != 0.0) {
            double dSquare = d * d;
            double dCube = dSquare * d;
            double dFour = dCube * d;
            double dFive = dFour * d;
            double dSix = dFive * d;
            double dSeven = dSix * d;
            double dEight = dSeven * d;
            double dNine = dEight * d;
            double fact1 = Math.pow(d / Math.E, d) * Math.sqrt(2.0 * d * Math.PI) * (1.0 + 1.0 / (12.0 * d) + 1.0 / (288.0 * dSquare) - 139.0 / (51840.0 * dCube) - 59909.0 / (2.592E8 * dFour) + 1208137.0 / (1.492992E9 * dFive) - 1151957.0 / (1.875E11 * dSix) - 101971.0 / (2.88E8 * dSeven) + 1.89401873E8 / (2.4E12 * dEight) + 1293019.0 / (1.8E10 * dNine));
            while (n + i <= 160.0) {
                prod *= dbVal + i;
                i += 1.0;
            }
            fact = fact1 / prod;
        } else if (dbVal > 160.0) {
            double fact1;
            double dbValSquare = dbVal * dbVal;
            double dbValCube = dbValSquare * dbVal;
            double dbValFour = dbValCube * dbVal;
            double dbValFive = dbValFour * dbVal;
            double dbValSix = dbValFive * dbVal;
            double dbValSeven = dbValSix * dbVal;
            double dbValEight = dbValSeven * dbVal;
            double dbValNine = dbValEight * dbVal;
            fact = fact1 = Math.pow(dbVal / Math.E, dbVal) * Math.sqrt(2.0 * dbVal * Math.PI) * (1.0 + 1.0 / (12.0 * dbVal) + 1.0 / (288.0 * dbValSquare) - 139.0 / (51840.0 * dbValCube) - 59909.0 / (2.592E8 * dbValFour) + 1208137.0 / (1.492992E9 * dbValFive) - 1151957.0 / (1.875E11 * dbValSix) - 101971.0 / (2.88E8 * dbValSeven) + 1.89401873E8 / (2.4E12 * dbValEight) + 1293019.0 / (1.8E10 * dbValNine));
        }
        fact5 = String.valueOf(fact);
        return fact5;
    }

    public static int getExponent(double num) {
        double absVal = Math.abs(num);
        int count = 0;
        if (absVal < 1.0) {
            while (absVal < 1.0) {
                absVal *= 10.0;
                ++count;
            }
            count *= -1;
        } else if (absVal > 10.0) {
            while (absVal > 10.0) {
                absVal /= 10.0;
                ++count;
            }
        }
        return count;
    }

    public static double logToAnyBase(double num, double base) {
        return Math.log(num) / Math.log(base);
    }

    public static double antiLogToAnyBase(double num, double base) {
        return Math.pow(base, num);
    }

    private static String sign(String num) {
        String sign = "";
        if (num.length() > 0) {
            sign = num.substring(0, 1).equals("+") || num.substring(0, 1).equals("-") ? num.substring(0, 1) : "+";
        }
        return sign;
    }

    private static boolean hasPoint(String num) {
        if (num.indexOf(".") >= 0) {
            return true;
        }
        if (num.indexOf(".") < 0) {
            return false;
        }
        return false;
    }

    private static boolean hasExponent(String num) {
        if (num.indexOf("E") >= 0) {
            return true;
        }
        if (num.indexOf("E") < 0) {
            return false;
        }
        return false;
    }

    private static boolean isNegNumber(String num) {
        return Maths.sign(num).equals("-");
    }

    private static boolean hasNegExponent(String num) {
        boolean yes = false;
        yes = Maths.hasExponent(num) && num.substring(num.indexOf("E") + 1, num.indexOf("E") + 2).equals("-");
        return yes;
    }

    private static boolean hasPosExponent(String num) {
        boolean yes = false;
        yes = Maths.hasExponent(num) && num.substring(num.indexOf("E") + 1, num.indexOf("E") + 2).equals("+");
        return yes;
    }

    private static boolean hasUnsignedExp(String num) {
        boolean yes = false;
        yes = Maths.hasExponent(num) && STRING.isDigit(num.substring(num.indexOf("E") + 1, num.indexOf("E") + 2));
        return yes;
    }

    private static String abs_val(String num) {
        num = Maths.isNegNumber(num) ? num.substring(1) : num + "";
        return num;
    }

    private static String getNumbersBeforePoint(String num) {
        String thenumbers = "";
        if (Maths.hasPoint(num)) {
            thenumbers = num.substring(0, num.indexOf("."));
        } else if (!Maths.hasPoint(num)) {
            thenumbers = "";
        }
        return thenumbers;
    }

    private static String getNumbersAfterPoint(String num) {
        String thenumbers = "";
        if (Maths.hasExponent(num)) {
            thenumbers = num.substring(num.indexOf(".") + 1, num.indexOf("E"));
        } else if (!Maths.hasExponent(num)) {
            thenumbers = num.substring(num.indexOf(".") + 1);
        } else if (!Maths.hasPoint(num)) {
            thenumbers = "";
        }
        return thenumbers;
    }

    private static String getNumbersAfterExp(String num) {
        String thenumbers = "";
        if (Maths.hasNegExponent(num) || Maths.hasPosExponent(num)) {
            thenumbers = num.substring(num.indexOf("E") + 2);
        } else if (Maths.hasUnsignedExp(num)) {
            thenumbers = num.substring(num.indexOf("E") + 1);
        } else if (!Maths.hasExponent(num)) {
            thenumbers = "0";
        }
        return thenumbers;
    }

    private static String generateZeroes(int n) {
        String gen = "";
        for (int i = 0; i < n; ++i) {
            gen = gen + "0";
        }
        return gen;
    }

    private static int getNumberOfLeadingZeroes(String num) {
        int index = 0;
        for (int i = 0; i < num.length() && num.substring(i, i + 1).equals("0"); ++i) {
            ++index;
        }
        return index;
    }

    protected static String std_form(String num) {
        String sign = Maths.sign(num);
        String abs_val = Maths.abs_val(num);
        if (!Maths.hasPoint(abs_val) && !Maths.hasExponent(abs_val)) {
            abs_val = abs_val + ".0E0";
        } else if (Maths.hasPoint(abs_val) && !Maths.hasExponent(abs_val)) {
            abs_val = abs_val + "E0";
        } else if (!Maths.hasPoint(abs_val) && Maths.hasExponent(abs_val)) {
            abs_val = abs_val.substring(0, abs_val.indexOf("E")) + ".0" + abs_val.substring(abs_val.indexOf("E"));
        } else if (Maths.hasPoint(abs_val) && Maths.hasExponent(abs_val)) {
            abs_val = abs_val + "";
        }
        String numbeforepoint = "";
        String the_std_form_of_num = "";
        long checkmethodgetNumbersBeforePoint = 0L;
        try {
            checkmethodgetNumbersBeforePoint = Long.valueOf(Maths.getNumbersBeforePoint(abs_val));
        }
        catch (NumberFormatException numa) {
            checkmethodgetNumbersBeforePoint = 0L;
        }
        if (checkmethodgetNumbersBeforePoint != 0L) {
            numbeforepoint = String.valueOf(checkmethodgetNumbersBeforePoint);
            String numafterexp = String.valueOf(Long.valueOf(Maths.getNumbersAfterExp(abs_val)));
            String transform_num_before_exp_to_std_form = numbeforepoint.substring(0, 1) + "." + numbeforepoint.substring(1) + Maths.getNumbersAfterPoint(abs_val) + "E" + (numbeforepoint.length() - 1);
            the_std_form_of_num = Maths.hasNegExponent(num) ? transform_num_before_exp_to_std_form.substring(0, transform_num_before_exp_to_std_form.indexOf("E")) + "E" + (-Long.valueOf(numafterexp).longValue() + Long.valueOf(transform_num_before_exp_to_std_form.substring(transform_num_before_exp_to_std_form.indexOf("E") + 1))) : transform_num_before_exp_to_std_form.substring(0, transform_num_before_exp_to_std_form.indexOf("E")) + "E" + (Long.valueOf(numafterexp) + Long.valueOf(transform_num_before_exp_to_std_form.substring(transform_num_before_exp_to_std_form.indexOf("E") + 1)));
        } else if (checkmethodgetNumbersBeforePoint == 0L) {
            numbeforepoint = "0";
            String numafterpoint = Maths.getNumbersAfterPoint(abs_val);
            String numafterpointwithoutleadingzeroes = String.valueOf(Long.valueOf(numafterpoint));
            String numafterexp = String.valueOf(Long.valueOf(Maths.getNumbersAfterExp(abs_val)));
            String transform_num_before_exp_to_std_form = numafterpointwithoutleadingzeroes.substring(0, 1) + "." + numafterpointwithoutleadingzeroes.substring(1) + "0E-" + (1 + Maths.getNumberOfLeadingZeroes(numafterpoint));
            the_std_form_of_num = Maths.hasNegExponent(num) ? transform_num_before_exp_to_std_form.substring(0, transform_num_before_exp_to_std_form.indexOf("E")) + "E" + (-Long.valueOf(numafterexp).longValue() + Long.valueOf(transform_num_before_exp_to_std_form.substring(transform_num_before_exp_to_std_form.indexOf("E") + 1))) : transform_num_before_exp_to_std_form.substring(0, transform_num_before_exp_to_std_form.indexOf("E")) + "E" + (Long.valueOf(numafterexp) + Long.valueOf(transform_num_before_exp_to_std_form.substring(transform_num_before_exp_to_std_form.indexOf("E") + 1)));
        }
        String standardized = "";
        if (sign.equals("+")) {
            standardized = the_std_form_of_num;
        } else if (sign.equals("-")) {
            standardized = sign + the_std_form_of_num;
        }
        int j = standardized.indexOf("E");
        String modify1 = standardized.substring(0, j + 1);
        String modify2 = standardized.substring(j + 1);
        for (int i = j - 1; i >= 0 && modify1.substring(i, i + 1).equals("0"); --i) {
            modify1 = STRING.replace(modify1, "", i, i + 1);
        }
        return modify1 + modify2;
    }

    public static String non_exp_format(String num) {
        String result = "";
        if (Maths.hasExponent(num)) {
            String std_form;
            String sign = Maths.sign(num);
            String abs_val = Maths.abs_val(num);
            String std_form1 = std_form = Maths.std_form(abs_val);
            std_form1 = STRING.delete(std_form1, ".");
            int L = std_form1.substring(0, std_form1.indexOf("E")).length();
            int expsize = Integer.valueOf(Maths.getNumbersAfterExp(std_form1));
            if (Maths.hasNegExponent(num)) {
                expsize *= -1;
            }
            if (expsize >= 0) {
                if (L > expsize) {
                    result = std_form1.substring(0, expsize + 1) + "." + std_form1.substring(expsize + 1, std_form1.indexOf("E"));
                } else if (L <= expsize) {
                    result = std_form1.substring(0, std_form1.indexOf("E")) + Maths.generateZeroes(expsize - L + 1);
                }
            } else if (expsize < 0) {
                result = "0." + Maths.generateZeroes(Math.abs(expsize) - 1) + std_form1.substring(0, std_form1.indexOf("E"));
            }
            result = sign.equals("-") ? sign + result : result + "";
        } else if (!Maths.hasExponent(num)) {
            result = num;
        }
        return result;
    }

    private static String whole_dec_to_other_base(String dec_no, String base_no) {
        if (!dec_no.contains(".") && !base_no.contains(".")) {
            int decimalno = 0;
            int baseno = 0;
            try {
                decimalno = Integer.parseInt(dec_no);
                baseno = Integer.parseInt(base_no);
                String h = "";
                while (decimalno > 0) {
                    int rem = decimalno % baseno;
                    h = h + rem;
                    if (rem == 0 && rem < baseno) {
                        decimalno /= baseno;
                        continue;
                    }
                    if (rem <= 0 || rem >= baseno) continue;
                    decimalno = (decimalno - rem) / baseno;
                }
                return STRING.reverse(h);
            }
            catch (NumberFormatException num) {
                System.out.println(dec_no);
                System.out.println(base_no);
                num.printStackTrace();
                throw new NumberFormatException("Only integers are expected here!");
            }
        }
        throw new NumberFormatException("Only integers are expected here!");
    }

    private static String frac_dec_to_other_base(String dec_no, String base_no) {
        String h = "";
        String j = "";
        double f = 0.0;
        double f1 = 0.0;
        try {
            f = Double.valueOf(dec_no);
            f1 = Integer.parseInt(base_no);
            while (h.length() <= 18) {
                h = h + String.valueOf(f1 * f).substring(0, String.valueOf(f1 * f).indexOf("."));
                if (f1 * f * f1 < f1) {
                    f = f1 * f;
                    continue;
                }
                if (!(f1 * f * f1 >= f1)) continue;
                f = Double.valueOf(String.valueOf(f1 * f).substring(String.valueOf(f1 * f).indexOf(".")));
            }
        }
        catch (NullPointerException nola) {
            h = STRING.reverse("PLEASE ENTER A NUMBER");
        }
        catch (NumberFormatException no) {
            h = STRING.reverse("NUMBER TOO LARGE");
        }
        catch (IndexOutOfBoundsException no) {
            // empty catch block
        }
        h = "." + h;
        int indexOfPoint = h.indexOf(".");
        if (indexOfPoint != -1) {
            int len = h.length();
            int i = len - 1;
            while (h.substring(i, i + 1).equals("0")) {
                --i;
            }
            if ((h = h.substring(0, i + 1)).endsWith(".")) {
                h = h + "0";
            }
        }
        return h;
    }

    public static String dec_to_other_base(String dec_no, String base_no) {
        if (dec_no.contains("E") || dec_no.contains("\u0404")) {
            dec_no = Maths.non_exp_format(dec_no);
        }
        String v = "";
        int kk = 0;
        for (int i = 0; i < dec_no.length(); ++i) {
            if (!dec_no.substring(i, i + 1).equals(".")) continue;
            ++kk;
            break;
        }
        String nio = "";
        if (dec_no.substring(0, 1).equals("-")) {
            nio = "-";
            v = dec_no.substring(1);
        } else if (!dec_no.substring(0, 1).equals("-")) {
            nio = "";
            v = dec_no;
        }
        String r = "";
        String y = "";
        if (kk == 0) {
            r = v;
            y = ".0";
        } else if (kk != 0) {
            r = v.substring(0, v.indexOf("."));
            y = v.substring(v.indexOf("."));
        }
        String v1 = Maths.whole_dec_to_other_base(r, base_no);
        String v2 = Maths.frac_dec_to_other_base(y, base_no);
        int u = 0;
        for (int i = 0; i < v2.length(); ++i) {
            if (!v2.substring(i, i + 1).equals("0") && !v2.substring(i, i + 1).equals(".")) {
                v2 = v2 + "";
                break;
            }
            ++u;
        }
        v2 = u == v2.length() ? ".0" : v2 + "";
        return nio + v1 + v2;
    }

    public static String num_to_base_10(String num, String num_base) {
        String h = "";
        if (Integer.valueOf(num_base) <= 1) {
            throw new NumberFormatException("Invalid Number Base.");
        }
        if (Integer.valueOf(num_base) > 1) {
            num = STRING.purifier(num);
            num_base = STRING.purifier(num_base);
            String nio = num;
            int point_watch = -1;
            for (int i = 0; i < num.length(); ++i) {
                if (STRING.isDigit(num.substring(i, i + 1)) && Integer.valueOf(num.substring(i, i + 1)) >= Integer.valueOf(num_base)) {
                    num = "";
                    throw new NumberFormatException();
                }
                if (!(num.substring(i, i + 1).equals(".") || STRING.isDigit(num.substring(i, i + 1)) || num.substring(i, i + 1).equals("-") || num.substring(i, i + 1).equals("E"))) {
                    num = "";
                    throw new NumberFormatException();
                }
                if (!num.substring(i, i + 1).equals(".")) continue;
                ++point_watch;
            }
            String v = "";
            v = num.substring(0, 1).equals("-") ? num.substring(1) : num;
            String r = "";
            String y = "";
            try {
                int i;
                int u = Integer.valueOf(num_base);
                if (point_watch == -1) {
                    r = v;
                    y = "0";
                    r = STRING.reverse(r);
                } else if (point_watch != -1) {
                    r = v.substring(0, v.indexOf("."));
                    y = v.substring(v.indexOf(".") + 1);
                    r = STRING.reverse(r);
                }
                double H = 0.0;
                for (i = 0; i < r.length(); ++i) {
                    H += Double.valueOf(r.substring(i, i + 1)) * Math.pow(u, i);
                }
                double Ha = 0.0;
                for (i = 0; i < y.length(); ++i) {
                    Ha += Double.valueOf(y.substring(i, i + 1)) * Math.pow(u, -i - 1);
                }
                H += Ha;
                if (nio.substring(0, 1).equals("-")) {
                    h = "-" + String.valueOf(H);
                } else if (!nio.substring(0, 1).equals("-")) {
                    h = String.valueOf(H);
                }
            }
            catch (NullPointerException nol) {
                h = "SYNTAX ERROR at null";
            }
            catch (IndexOutOfBoundsException ind) {
                h = "SYNTAX ERROR at ind";
                ind.printStackTrace();
            }
            catch (NumberFormatException numa) {
                h = "SYNTAX ERROR at numa";
                numa.printStackTrace();
            }
        }
        return h;
    }

    public static String changeBase(String num, String num_base, String base) {
        String h = Maths.num_to_base_10(num, num_base);
        String val = Maths.dec_to_other_base(h, base);
        return val.startsWith(".") ? 0 + val : val;
    }

    public static String add(String num1, int base1, String num2, int base2, int resultbase) {
        String no1_to_base10 = Maths.changeBase(num1, String.valueOf(base1), "10");
        String no2_to_base10 = Maths.changeBase(num2, String.valueOf(base2), "10");
        return Maths.changeBase(String.valueOf(Double.parseDouble(no1_to_base10) + Double.parseDouble(no2_to_base10)), "10", String.valueOf(resultbase));
    }

    public static String subtract(String num1, int base1, String num2, int base2, int resultbase) {
        String no1_to_base10 = Maths.changeBase(num1, String.valueOf(base1), "10");
        String no2_to_base10 = Maths.changeBase(num2, String.valueOf(base2), "10");
        return Maths.changeBase(String.valueOf(Double.parseDouble(no1_to_base10) - Double.parseDouble(no2_to_base10)), "10", String.valueOf(resultbase));
    }

    public static String divide(String num1, int base1, String num2, int base2, int resultbase) {
        String no1_to_base10 = Maths.changeBase(num1, String.valueOf(base1), "10");
        String no2_to_base10 = Maths.changeBase(num2, String.valueOf(base2), "10");
        return Maths.changeBase(String.valueOf(Double.parseDouble(no1_to_base10) / Double.parseDouble(no2_to_base10)), "10", String.valueOf(resultbase));
    }

    public static String multiply(String num1, int base1, String num2, int base2, int resultbase) {
        String no1_to_base10 = Maths.changeBase(num1, String.valueOf(base1), "10");
        String no2_to_base10 = Maths.changeBase(num2, String.valueOf(base2), "10");
        return Maths.changeBase(String.valueOf(Double.parseDouble(no1_to_base10) * Double.parseDouble(no2_to_base10)), "10", String.valueOf(resultbase));
    }

    public static List<String> scanintoList(String s) {
        s = s + ",";
        String acc = "";
        int commacounter = 0;
        ArrayList<String> input = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            acc = acc + s.substring(i, i + 1);
            if (!s.substring(i, i + 1).equals(",")) continue;
            acc = Maths.non_exp_format(acc);
            try {
                input.add(STRING.delete(acc, ","));
                acc = "";
                ++commacounter;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return input;
    }

    public static double degToRad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static double radToDeg(double rad) {
        return rad * 57.29577951308232;
    }

    public static double degToGrad(double deg) {
        return 10.0 * deg / 9.0;
    }

    public static double gradToDeg(double grad) {
        return 0.9 * grad;
    }

    public static double radToGrad(double rad) {
        return rad * 63.66197723675813;
    }

    public static double gradToRad(double grad) {
        return grad * 0.015707963267948967;
    }

    public static double sinRadToDeg(double angRad) {
        return Math.sin(Maths.radToDeg(angRad));
    }

    public static double sinDegToRad(double angDeg) {
        return Math.sin(Maths.degToRad(angDeg));
    }

    public static double sinRadToGrad(double angRad) {
        return Math.sin(Maths.radToGrad(angRad));
    }

    public static double sinGradToRad(double angGrad) {
        return Math.sin(Maths.gradToRad(angGrad));
    }

    public static double sinDegToGrad(double angGrad) {
        return Math.sin(Maths.degToGrad(angGrad));
    }

    public static double sinGradToDeg(double angDeg) {
        return Math.sin(Maths.gradToDeg(angDeg));
    }

    public static double cosRadToDeg(double angRad) {
        return Math.cos(Maths.radToDeg(angRad));
    }

    public static double cosDegToRad(double angDeg) {
        return Math.cos(Maths.degToRad(angDeg));
    }

    public static double cosRadToGrad(double angRad) {
        return Math.cos(Maths.radToGrad(angRad));
    }

    public static double cosGradToRad(double angGrad) {
        return Math.cos(Maths.gradToRad(angGrad));
    }

    public static double cosDegToGrad(double angGrad) {
        return Math.cos(Maths.degToGrad(angGrad));
    }

    public static double cosGradToDeg(double angDeg) {
        return Math.cos(Maths.gradToDeg(angDeg));
    }

    public static double tanRadToDeg(double angRad) {
        return Math.tan(Maths.radToDeg(angRad));
    }

    public static double tanDegToRad(double angDeg) {
        return Math.tan(Maths.degToRad(angDeg));
    }

    public static double tanRadToGrad(double angRad) {
        return Math.tan(Maths.radToGrad(angRad));
    }

    public static double tanGradToRad(double angGrad) {
        return Math.tan(Maths.gradToRad(angGrad));
    }

    public static double tanDegToGrad(double angGrad) {
        return Math.tan(Maths.degToGrad(angGrad));
    }

    public static double tanGradToDeg(double angDeg) {
        return Math.tan(Maths.gradToDeg(angDeg));
    }

    public static double atanRadToDeg(double angRad) {
        return Maths.radToDeg(Maths.atan(angRad));
    }

    public static double acosRadToDeg(double angRad) {
        return Maths.radToDeg(Maths.acos(angRad));
    }

    public static double asinRadToDeg(double angRad) {
        return Maths.radToDeg(Maths.asin(angRad));
    }

    public static double asinDegToRad(double angDeg) {
        return Maths.degToRad(Maths.asin(angDeg));
    }

    public static double asinRadToGrad(double angRad) {
        return Maths.radToGrad(Maths.asin(angRad));
    }

    public static double asinGradToRad(double angGrad) {
        return Maths.gradToRad(Maths.asin(angGrad));
    }

    public static double asinDegToGrad(double angDeg) {
        return Maths.asinDegToGrad(angDeg);
    }

    public static double asinGradToDeg(double angGrad) {
        return Maths.gradToDeg(Maths.asin(angGrad));
    }

    public static double acosDegToRad(double angDeg) {
        return Maths.degToRad(Maths.acos(angDeg));
    }

    public static double acosRadToGrad(double angRad) {
        return Maths.radToGrad(Maths.acos(angRad));
    }

    public static double acosGradToRad(double angGrad) {
        return Maths.gradToRad(Maths.acos(angGrad));
    }

    public static double acosDegToGrad(double angDeg) {
        return Maths.acosDegToGrad(angDeg);
    }

    public static double acosGradToDeg(double angGrad) {
        return Maths.gradToDeg(Maths.acos(angGrad));
    }

    public static double atanDegToRad(double angDeg) {
        return Maths.degToRad(Maths.atan(angDeg));
    }

    public static double atanRadToGrad(double angRad) {
        return Maths.radToGrad(Maths.atan(angRad));
    }

    public static double atanGradToRad(double angGrad) {
        return Maths.gradToRad(Maths.atan(angGrad));
    }

    public static double atanDegToGrad(double angDeg) {
        return Maths.atanDegToGrad(angDeg);
    }

    public static double atanGradToDeg(double angGrad) {
        return Maths.gradToDeg(Maths.atan(angGrad));
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static double acsch(double x) {
        return Maths.asinh(1.0 / x);
    }

    public static double asech(double x) {
        return Maths.acosh(1.0 / x);
    }

    public static double acoth(double x) {
        return Maths.atanh(1.0 / x);
    }

    public static double power(double number, double exponent) {
        if (exponent == 0.0) {
            return 1.0;
        }
        if (exponent < 0.0) {
            exponent = -exponent;
            if (number == 0.0) {
                return 0.0;
            }
            if (number < 0.0) {
                if (exponent % 2.0 == 0.0 || exponent % 2.0 == 1.0) {
                    return 1.0 / Maths.pow(number, exponent);
                }
                return Double.NaN;
            }
            if (number > 0.0) {
                if (exponent % 2.0 == 0.0 || exponent % 2.0 == 1.0) {
                    return 1.0 / Maths.pow(number, exponent);
                }
                return Maths.exp(-exponent * Maths.log(number));
            }
            return Double.NaN;
        }
        if (number == 0.0) {
            return 0.0;
        }
        if (number < 0.0) {
            if (exponent % 2.0 == 0.0 || exponent % 2.0 == 1.0) {
                return Maths.pow(number, exponent);
            }
            return Double.NaN;
        }
        if (number > 0.0) {
            if (exponent % 2.0 == 0.0 || exponent % 2.0 == 1.0) {
                return Maths.pow(number, exponent);
            }
            return Maths.exp(exponent * Maths.log(number));
        }
        return Double.NaN;
    }

    public static double cbrt(double d) {
        if (d > 0.0) {
            return Maths.power(d, 0.3333333333333333);
        }
        return -Maths.power(Math.abs(d), 0.3333333333333333);
    }

    public static double pow(double number, double exponent) {
        int pow = (int)exponent;
        double result = 1.0;
        for (int i = 0; i < pow; ++i) {
            result *= number;
        }
        return result;
    }

    public static double log(double x) {
        if (x <= 0.0) {
            return Double.NaN;
        }
        double count = 1.0;
        while (Math.abs(x - 1.0) >= 0.1) {
            x = Math.sqrt(x);
            count += 1.0;
        }
        count = Maths.pow(2.0, count - 1.0);
        double sum = 0.0;
        double lastSum = 1.0E-11;
        double i = 1.0;
        double xCalc = (x - 1.0) / (x + 1.0);
        while (Math.abs(sum - lastSum) > 0.0) {
            lastSum = sum;
            sum += Maths.pow(xCalc, i) / i;
            i += 2.0;
        }
        return 2.0 * sum * count;
    }

    public static double exp(double x) {
        boolean isPos = x >= 0.0;
        if ((x = Math.abs(x)) <= 2.0) {
            double sum = 0.0;
            double fact = 1.0;
            double lastSum = 1.0E-11;
            double i = 0.0;
            while (Math.abs(sum - lastSum) > 0.0) {
                lastSum = sum;
                fact = i == 0.0 || i == 1.0 ? 1.0 : (fact *= i);
                sum += Maths.pow(x, i) / fact;
                i += 1.0;
            }
            if (!isPos) {
                return 1.0 / sum;
            }
            return sum;
        }
        if (!isPos) {
            return 1.0 / Maths.pow(Maths.exp(x / 15.0), 15.0);
        }
        return Maths.pow(Maths.exp(x / 15.0), 15.0);
    }

    public static double asin(double q) {
        if (Math.abs(q) <= 1.0) {
            double x = q / Math.sqrt(1.0 - q * q);
            return Maths.atan(x);
        }
        throw new ArithmeticException("x = " + q + " does not lie between -1 and 1.");
    }

    public static double acos(double p) {
        if (Math.abs(p) <= 1.0) {
            double x = Math.sqrt(1.0 - p * p) / p;
            return Maths.atan(x);
        }
        throw new ArithmeticException("x = " + p + " does not lie between -1 and 1.");
    }

    public static double atan(double x) {
        boolean isPositive = true;
        if (x > 0.0) {
            isPositive = true;
        } else {
            isPositive = false;
            x = -x;
        }
        if (x > 1.0) {
            double a = 0.0;
            double x_inv = 1.0 / x;
            double x_inv_squared = x_inv * x_inv;
            double prod = 1.0;
            for (int i = 0; i < 10; ++i) {
                if (i == 0) {
                    prod = x_inv;
                } else {
                    prod *= x_inv_squared;
                    prod /= (double)(2 * i + 1);
                }
                if (i % 2 == 0) {
                    a += prod;
                    continue;
                }
                a -= prod;
            }
            double x_n = a;
            double x_n1 = 0.0;
            while (true) {
                double sec_n = 1.0 / Math.cos(x_n);
                double tan_n = Math.tan(x_n);
                x_n1 = x_n - (tan_n - x_inv) / (sec_n * sec_n);
                if (Math.abs(x_n1 - x_n) <= 1.0E-14) break;
                x_n = x_n1;
            }
            if (isPositive) {
                return 1.5707963267948966 - x_n1;
            }
            return -1.0 * (1.5707963267948966 - x_n1);
        }
        double a = 0.0;
        double x_squared = x * x;
        double prod = 1.0;
        for (int i = 0; i < 10; ++i) {
            if (i == 0) {
                prod = x;
            } else {
                prod *= x_squared;
                prod /= (double)(2 * i + 1);
            }
            if (i % 2 == 0) {
                a += prod;
                continue;
            }
            a -= prod;
        }
        double x_n = a;
        double x_n1 = 0.0;
        while (true) {
            double sec_n = 1.0 / Math.cos(x_n);
            double tan_n = Math.tan(x_n);
            x_n1 = x_n - (tan_n - x) / (sec_n * sec_n);
            if (Math.abs(x_n1 - x_n) <= 1.0E-14) break;
            x_n = x_n1;
        }
        if (isPositive) {
            return x_n1;
        }
        return -1.0 * x_n1;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            Math.asin(0.3);
            Maths.asin(0.3);
        }
        double x = 0.99;
        double t1 = System.nanoTime();
        double val = Math.asin(x);
        double t2 = System.nanoTime();
        System.out.println("ans = " + val);
        System.out.println(" RUNTIME = " + (t2 - t1) / 1000000.0 + " ms");
        double t3 = System.nanoTime();
        val = Maths.asin(x);
        double t4 = System.nanoTime();
        System.out.println("ans = " + val);
        System.out.println(" RUNTIME = " + (t4 - t3) / 1000000.0 + " ms");
    }
}

