/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.tool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final Function<Integer, String> nameCreator;

    public NamedThreadFactory(Function<Integer, String> nameCreator) {
        this.nameCreator = nameCreator;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.group, r, this.nameCreator.apply(this.threadNumber.getAndIncrement()), 0L);
    }
}

