/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.rabbitmq.mock.configuration;

import com.github.fridujo.rabbitmq.mock.AmqArguments;
import com.github.fridujo.rabbitmq.mock.MockChannel;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueueDeclarator {
    private final String queueName;
    private final Map<String, Object> queueArgs = new LinkedHashMap<String, Object>();

    private QueueDeclarator(String queueName) {
        this.queueName = queueName;
    }

    public static QueueDeclarator queue(String queueName) {
        return new QueueDeclarator(queueName);
    }

    public static QueueDeclarator dynamicQueue() {
        return QueueDeclarator.queue("");
    }

    public QueueDeclarator withMessageTtl(long messageTtlInMs) {
        this.queueArgs.put("x-message-ttl", messageTtlInMs);
        return this;
    }

    public QueueDeclarator withDeadLetterExchange(String deadLetterExchange) {
        this.queueArgs.put("x-dead-letter-exchange", deadLetterExchange);
        return this;
    }

    public QueueDeclarator withDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.queueArgs.put("x-dead-letter-routing-key", deadLetterRoutingKey);
        return this;
    }

    public QueueDeclarator withMaxLength(int maxLength) {
        this.queueArgs.put("x-max-length", maxLength);
        return this;
    }

    public QueueDeclarator withMaxLengthBytes(int maxLengthBytes) {
        this.queueArgs.put("x-max-length-bytes", maxLengthBytes);
        return this;
    }

    public QueueDeclarator withOverflow(AmqArguments.Overflow overflow) {
        this.queueArgs.put("x-overflow", overflow.toString());
        return this;
    }

    public QueueDeclarator withMaxPriority(int maxPriority) {
        this.queueArgs.put("x-max-priority", maxPriority);
        return this;
    }

    public AMQP.Queue.DeclareOk declare(Channel channel) throws IOException {
        return channel.queueDeclare(this.queueName, true, false, false, this.queueArgs);
    }

    public AMQP.Queue.DeclareOk declare(MockChannel channel) {
        return channel.queueDeclare(this.queueName, true, false, false, this.queueArgs);
    }
}

