/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.lexer;

import com.github.fridujo.glacio.parsing.lexer.TokenType;

public enum FixedTokenDefinition {
    EOL(TokenType.EOL, '\n'),
    COLON(TokenType.COLON, ':'),
    TAG_DELIMITER(TokenType.TAG_DELIMITER, '@'),
    COMMENT_DELIMITER(TokenType.COMMENT_DELIMITER, '#'),
    TABLE_DELIMITER(TokenType.TABLE_DELIMITER, '|'),
    DOC_STRING_DELIMITER(TokenType.DOC_STRING_DELIMITER, "\"\"\"");

    private final TokenType type;
    private final char singleCharacter;
    private final String literalString;

    private FixedTokenDefinition(TokenType type, char literalCharacter) {
        this.type = type;
        this.singleCharacter = literalCharacter;
        this.literalString = String.valueOf(literalCharacter);
    }

    private FixedTokenDefinition(TokenType type, String literalString) {
        this.type = type;
        this.singleCharacter = '\u0000';
        this.literalString = literalString;
    }

    public TokenType getType() {
        return this.type;
    }

    public char getSingleCharacter() {
        return this.singleCharacter;
    }

    public String getLiteralString() {
        return this.literalString;
    }
}

