/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.reader;

import com.github.fracpete.processoutput4j.core.AbstractProcessRunnable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class AbstractProcessReader
extends AbstractProcessRunnable {
    protected boolean m_Stdout;
    protected BufferedReader m_Reader;

    public AbstractProcessReader(boolean stdout) {
        this.m_Stdout = stdout;
    }

    public boolean isStdout() {
        return this.m_Stdout;
    }

    protected abstract void process(String var1);

    public void flush() {
        while (this.m_Reader != null) {
            try {
                String line = this.m_Reader.readLine();
                if (line == null) break;
                this.process(line);
            }
            catch (IOException e) {
                break;
            }
            catch (Exception e) {
                this.logError("Failed to flush!", e);
                break;
            }
        }
    }

    @Override
    protected void doRun() {
        try {
            this.m_Reader = this.m_Stdout ? new BufferedReader(new InputStreamReader(this.m_Process.getInputStream())) : new BufferedReader(new InputStreamReader(this.m_Process.getErrorStream()));
            while (this.m_Process.isAlive()) {
                String line;
                try {
                    line = this.m_Reader.readLine();
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().toLowerCase().contains("stream closed")) {
                        return;
                    }
                    throw ioe;
                }
                if (line == null) continue;
                this.process(line);
            }
            this.flush();
        }
        catch (Exception e) {
            System.err.println("Failed to read from " + (this.m_Stdout ? "stdout" : "stderr") + " for process #" + this.m_Process.hashCode() + ":");
            e.printStackTrace();
        }
    }
}

