/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.strings;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

@RedisCommand(value="set")
class Set
extends AbstractRedisOperation {
    private final List<String> additionalParams = this.params().stream().skip(2L).map(Slice::toString).collect(Collectors.toList());

    Set(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    @Override
    protected Slice response() {
        BiConsumer<Slice, RMDataStructure> valueSetter;
        Slice key = this.params().get(0);
        Slice value = this.params().get(1);
        try {
            valueSetter = this.valueSetter();
        }
        catch (IllegalArgumentException e) {
            return Response.error(e.getMessage());
        }
        if (this.nx()) {
            Slice old = this.base().getSlice(key);
            if (old == null) {
                valueSetter.accept(key, value.extract());
                return Response.OK;
            }
            return Response.NULL;
        }
        if (this.xx()) {
            Slice old = this.base().getSlice(key);
            if (old == null) {
                return Response.NULL;
            }
            valueSetter.accept(key, value.extract());
            return Response.OK;
        }
        valueSetter.accept(key, value.extract());
        return Response.OK;
    }

    private boolean nx() {
        return this.additionalParams.stream().anyMatch("nx"::equalsIgnoreCase);
    }

    private boolean xx() {
        return this.additionalParams.stream().anyMatch("xx"::equalsIgnoreCase);
    }

    private boolean keepTTL() {
        return this.additionalParams.stream().anyMatch("keepttl"::equalsIgnoreCase);
    }

    private long parseAndValidate(String param, int multiplier) {
        long value = Utils.convertToLong(param);
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format("ERR invalid expire time in '%s' command", this.self().value()));
        }
        try {
            value = Math.multiplyExact((long)multiplier, value);
            Math.addExact(this.base().getClock().millis(), value);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(String.format("ERR invalid expire time in '%s' command", this.self().value()));
        }
        return value;
    }

    private BiConsumer<Slice, RMDataStructure> valueSetter() {
        String previous = null;
        for (String param : this.additionalParams) {
            if ("ex".equalsIgnoreCase(previous)) {
                long ex = this.parseAndValidate(param, 1000);
                return (k, v) -> this.base().putValue((Slice)k, (RMDataStructure)v, ex);
            }
            if ("px".equalsIgnoreCase(previous)) {
                long px = this.parseAndValidate(param, 1);
                return (k, v) -> this.base().putValue((Slice)k, (RMDataStructure)v, px);
            }
            if ("exat".equalsIgnoreCase(previous)) {
                long exat = this.parseAndValidate(param, 1000);
                return (k, v) -> {
                    this.base().putValue((Slice)k, (RMDataStructure)v);
                    this.base().setDeadline((Slice)k, exat);
                };
            }
            if ("pxat".equalsIgnoreCase(previous)) {
                long pxat = this.parseAndValidate(param, 1);
                return (k, v) -> {
                    this.base().putValue((Slice)k, (RMDataStructure)v);
                    this.base().setDeadline((Slice)k, pxat);
                };
            }
            previous = param;
        }
        if (this.keepTTL()) {
            return (k, v) -> {
                Long deadline = this.base().getDeadline((Slice)k);
                this.base().putValue((Slice)k, (RMDataStructure)v);
                this.base().setDeadline((Slice)k, deadline);
            };
        }
        return (k, v) -> this.base().putValue((Slice)k, (RMDataStructure)v);
    }
}

