/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class RMString
implements RMDataStructure,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] storedData;

    public RMString() {
        this.storedData = new byte[0];
    }

    public RMString(byte[] data) {
        this.storedData = data;
    }

    public byte[] getStoredData() {
        return Arrays.copyOf(this.storedData, this.storedData.length);
    }

    public String getStoredDataAsString() {
        return new String(this.storedData, StandardCharsets.UTF_8);
    }

    public static RMString create(byte[] str) {
        return new RMString(str);
    }

    public static RMString create(String str) {
        return new RMString(str.getBytes(StandardCharsets.UTF_8));
    }

    public void add(byte[] str) {
        int oldLength = this.storedData.length;
        this.storedData = Arrays.copyOf(this.storedData, oldLength + str.length);
        System.arraycopy(str, 0, this.storedData, oldLength, str.length);
    }

    public int size() {
        return this.storedData.length;
    }

    @Override
    public void raiseTypeCastException() {
        throw new WrongValueTypeException("WRONGTYPE RMString value is used in the wrong place");
    }

    @Override
    public String getTypeName() {
        return "string";
    }

    @Override
    public Slice getAsSlice() {
        return Slice.create(this.storedData);
    }
}

