/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hashes;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.hashes.HIncrBy;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

@RedisCommand(value="hincrbyfloat")
class HIncrByFloat
extends HIncrBy {
    HIncrByFloat(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private void validateHIncrByFloatArgument(Slice input) {
        String errorMessage = "ERROR: HINCRBYFLOAT argument is not a float value";
        String foundValueStr = String.valueOf(input);
        if (foundValueStr.startsWith(" ") || foundValueStr.endsWith(" ")) {
            throw new IllegalArgumentException("ERROR: HINCRBYFLOAT argument is not a float value");
        }
        byte[] bts = input.data();
        for (int i = 0; i < bts.length; ++i) {
            if (bts[i] != 0) continue;
            throw new IllegalArgumentException("ERROR: HINCRBYFLOAT argument is not a float value");
        }
    }

    @Override
    Slice hsetValue(Slice key1, Slice key2, Slice value) {
        double numericValue = Utils.convertToDouble(String.valueOf(value));
        Slice foundValue = this.base().getSlice(key1, key2);
        if (foundValue != null) {
            this.validateHIncrByFloatArgument(foundValue);
            numericValue = Utils.convertToDouble(new String(foundValue.data())) + numericValue;
        }
        DecimalFormatSymbols separator = new DecimalFormatSymbols(Locale.getDefault());
        separator.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("#.#################", separator);
        Slice res = Slice.create(formatter.format(numericValue));
        this.base().putSlice(key1, key2, res, -1L);
        return Response.bulkString(res);
    }

    @Override
    protected Slice response() {
        Slice key1 = this.params().get(0);
        Slice key2 = this.params().get(1);
        Slice value = this.params().get(2);
        return this.hsetValue(key1, key2, value);
    }
}

