/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.github.fommil.netlib.generator.JarMethodScanner;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.DefaultParanamer;
import com.thoughtworks.paranamer.JavadocParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractNetlibGenerator
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/netlib-java", required=true)
    protected File outputDir;
    @Parameter(required=true)
    protected String outputName;
    @Parameter(defaultValue="net.sourceforge.f2j:arpack_combined_all:jar:0.1", required=true)
    protected String input;
    @Parameter(defaultValue="net.sourceforge.f2j:arpack_combined_all:jar:javadoc:0.1")
    protected String javadoc;
    @Parameter(required=true)
    protected String scan;
    @Parameter
    protected String exclude;
    @Component
    protected MavenProject project;
    protected Paranamer paranamer = new DefaultParanamer();

    protected File getFile(String artifactName) {
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.toString().startsWith(artifactName)) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("could not find " + artifactName + " in " + this.project.getArtifacts());
    }

    protected abstract String generate(List<Method> var1) throws Exception;

    public void execute() throws MojoExecutionException {
        try {
            this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
            File output = new File(this.outputDir, this.outputName);
            if (output.exists() && this.project.getFile().lastModified() < output.lastModified()) {
                this.getLog().info((CharSequence)("No changes detected, skipping: " + output));
                return;
            }
            if (Strings.isNullOrEmpty((String)this.javadoc)) {
                this.getLog().warn((CharSequence)"Javadocs not attached for paranamer.");
            } else {
                this.paranamer = new CachingParanamer((Paranamer)new JavadocParanamer(this.getFile(this.javadoc)));
            }
            File jar = this.getFile(this.input);
            JarMethodScanner scanner = new JarMethodScanner(jar);
            ArrayList methods = Lists.newArrayList((Iterable)Iterables.filter(scanner.getStaticMethods(this.scan), (Predicate)new Predicate<Method>(){

                public boolean apply(Method input) {
                    return AbstractNetlibGenerator.this.exclude == null || !input.getName().matches(AbstractNetlibGenerator.this.exclude);
                }
            }));
            String generated = this.generate(methods);
            output.getParentFile().mkdirs();
            this.getLog().info((CharSequence)("Generating " + output.getAbsoluteFile()));
            Files.write((CharSequence)generated, (File)output, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new MojoExecutionException("java generation", e);
        }
    }

    protected List<String> getNetlibJavaParameterNames(Method method, boolean offsets) {
        final ArrayList params = Lists.newArrayList();
        this.iterateRelevantParameters(method, offsets, new ParameterCallback(){

            @Override
            public void process(int i, Class<?> param, String name, String offsetName) {
                params.add(name);
            }
        });
        return params;
    }

    protected List<String> getNetlibJavaParameterTypes(Method method, boolean offsets) {
        final ArrayList types = Lists.newArrayList();
        this.iterateRelevantParameters(method, offsets, new ParameterCallback(){

            @Override
            public void process(int i, Class<?> param, String name, String offsetName) {
                types.add(param.getCanonicalName());
            }
        });
        return types;
    }

    protected void iterateRelevantParameters(Method method, boolean offsets, ParameterCallback callback) {
        if (method.getParameterTypes().length == 0) {
            return;
        }
        String[] names = new String[]{};
        try {
            names = this.paranamer.lookupParameterNames((AccessibleObject)method, true);
        }
        catch (ParameterNamesNotFoundException e) {
            this.getLog().warn((Throwable)e);
        }
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> param = method.getParameterTypes()[i];
            if (i > 0 && !offsets && param == Integer.TYPE && method.getParameterTypes()[i - 1].isArray()) continue;
            String name = names.length > 0 ? names[i] : "arg" + i;
            String offsetName = null;
            if (i < method.getParameterTypes().length - 1 && param.isArray() && method.getParameterTypes()[i + 1] == Integer.TYPE) {
                offsetName = names[i + 1];
            }
            callback.process(i, param, name, offsetName);
        }
    }

    public boolean hasOffsets(Method method) {
        Class<?> last = null;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> param = method.getParameterTypes()[i];
            if (last != null && last.isArray() && param.equals(Integer.TYPE)) {
                return true;
            }
            last = param;
        }
        return false;
    }

    protected static interface ParameterCallback {
        public void process(int var1, Class<?> var2, String var3, @Nullable String var4);
    }
}

