/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.github.fommil.netlib.generator.AbstractNetlibGenerator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

@Mojo(name="native-jni", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NativeImplJniGenerator
extends AbstractNetlibGenerator {
    protected final STGroupFile jniTemplates = new STGroupFile("com/github/fommil/netlib/generator/netlib-jni.stg", '$', '$');
    @Parameter(required=true)
    protected String implementing;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected String prefix = "";
    @Parameter
    protected String suffix = "";
    @Parameter
    protected String firstParam;
    @Parameter
    protected String noFirstParam;
    @Parameter
    protected boolean cblas_hack;
    @Parameter
    protected boolean lapacke_hack;
    @Parameter
    protected boolean fortran_hack;
    @Parameter
    protected boolean extractChar;

    @Override
    protected String generate(List<Method> methods) throws Exception {
        ST t = this.jniTemplates.getInstanceOf("jni");
        if (this.includes == null) {
            this.includes = Lists.newArrayList();
        }
        this.includes.add(this.outputName.replace(".c", ".h"));
        t.add("includes", this.includes);
        ArrayList members = Lists.newArrayList();
        for (Method method : methods) {
            members.add(this.render(method, false));
            if (!this.hasOffsets(method)) continue;
            members.add(this.render(method, true));
        }
        t.add("members", (Object)members);
        return t.render();
    }

    private String render(Method method, boolean offsets) {
        ST f = this.jniTemplates.getInstanceOf("function");
        f.add("returns", (Object)this.jType2C(method.getReturnType()));
        f.add("fqn", (Object)((this.implementing + "." + method.getName()).replace(".", "_") + (offsets ? "_1offsets" : "")));
        f.add("name", (Object)(this.prefix + method.getName() + this.suffix));
        List<String> params = this.getNetlibCParameterTypes(method, offsets);
        List<String> names = this.getNetlibJavaParameterNames(method, offsets);
        f.add("paramTypes", params);
        f.add("paramNames", names);
        f.add("params", this.getCMethodParams(method, offsets));
        if (method.getReturnType() == Void.TYPE) {
            if (this.lapacke_hack && ((String)Iterables.getLast(names)).equals("info")) {
                f.add("assignReturn", (Object)"int returnValue = ");
            } else {
                f.add("assignReturn", (Object)"");
            }
            f.add("return", (Object)"");
        } else {
            f.add("assignReturn", (Object)(this.jType2C(method.getReturnType()) + " returnValue = "));
            f.add("return", (Object)"return returnValue;");
        }
        ArrayList init = Lists.newArrayList();
        ArrayList clean = Lists.newArrayList();
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            String name = names.get(i);
            ST before = this.jniTemplates.getInstanceOf(param + "_init");
            if (this.lapacke_hack && name.equals("info")) {
                before = this.jniTemplates.getInstanceOf(param + "_info_init");
            }
            if (before != null) {
                before.add("name", (Object)name);
                init.add(before.render());
            }
            ST after = this.jniTemplates.getInstanceOf(param + "_clean");
            if (this.lapacke_hack && name.equals("info")) {
                after = this.jniTemplates.getInstanceOf(param + "_info_clean");
            }
            if (after == null) continue;
            after.add("name", (Object)name);
            clean.add(after.render());
        }
        Collections.reverse(clean);
        f.add("init", (Object)init);
        f.add("clean", (Object)clean);
        return f.render();
    }

    private List<String> getNetlibCParameterTypes(Method method, boolean offsets) {
        final ArrayList types = Lists.newArrayList();
        this.iterateRelevantParameters(method, offsets, new AbstractNetlibGenerator.ParameterCallback(){

            @Override
            public void process(int i, Class<?> param, String name, String offsetName) {
                types.add(NativeImplJniGenerator.this.jType2C(param));
            }
        });
        return types;
    }

    private String jType2C(Class param) {
        if (param == Void.TYPE) {
            return "void";
        }
        if (param.isArray()) {
            return "j" + param.getComponentType().getSimpleName() + "Array";
        }
        return "j" + param.getSimpleName().toLowerCase();
    }

    private List<String> getCMethodParams(final Method method, final boolean offsets) {
        final LinkedList params = Lists.newLinkedList();
        if (this.firstParam != null && !method.getName().matches(this.noFirstParam)) {
            params.add(this.firstParam);
        }
        this.iterateRelevantParameters(method, false, new AbstractNetlibGenerator.ParameterCallback(){

            @Override
            public void process(int i, Class<?> param, String name, String offsetName) {
                if (NativeImplJniGenerator.this.lapacke_hack && name.equals("info")) {
                    return;
                }
                if (param == Object.class) {
                    throw new UnsupportedOperationException(method + " " + param + " " + name);
                }
                if (param == Boolean.TYPE || !param.isPrimitive()) {
                    name = "jni_" + name;
                    if (!param.getSimpleName().equals("StringW") && param.getSimpleName().endsWith("W")) {
                        name = "&" + name;
                    }
                }
                if (param == String.class && NativeImplJniGenerator.this.cblas_hack) {
                    if (name.contains("trans")) {
                        name = "getCblasTrans(" + name + ")";
                    } else if (name.contains("uplo")) {
                        name = "getCblasUpLo(" + name + ")";
                    } else if (name.contains("side")) {
                        name = "getCblasSide(" + name + ")";
                    } else if (name.contains("diag")) {
                        name = "getCblasDiag(" + name + ")";
                    }
                }
                if (!NativeImplJniGenerator.this.fortran_hack && param == String.class && NativeImplJniGenerator.this.extractChar) {
                    name = name + "[0]";
                }
                if (NativeImplJniGenerator.this.fortran_hack && param.isPrimitive()) {
                    name = "&" + name;
                }
                if (offsets & offsetName != null) {
                    name = name + " + " + offsetName;
                }
                params.add(name);
            }
        });
        return params;
    }
}

