/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.resp3;

import com.github.fmjsjx.libnetty.resp.DefaultArrayMessage;
import com.github.fmjsjx.libnetty.resp.RespMessage;
import com.github.fmjsjx.libnetty.resp.RespMessages;
import com.github.fmjsjx.libnetty.resp.RespSimpleStringMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

class TestClientHandler
extends SimpleChannelInboundHandler<RespMessage> {
    private int count = 0;
    private boolean quited = false;

    TestClientHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, RespMessage msg) throws Exception {
        System.out.println("-- RESP message received --");
        System.out.println(msg);
        if (this.quited && msg instanceof RespSimpleStringMessage && RespMessages.ok().value().equals(((RespSimpleStringMessage)msg).value())) {
            System.out.println("QUIT is OK");
            ctx.close();
            return;
        }
        switch (this.count++) {
            case 0: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "ECHO", "Hello World!"));
                break;
            }
            case 1: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "SMEMBERS", "any key for test"));
                break;
            }
            case 2: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "SMEMBERS", "12"));
                break;
            }
            case 3: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "HGETALL", "any key for test"));
                break;
            }
            case 4: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "PING", "PING may same with ECHO"));
                break;
            }
            case 5: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "GET", "https://www.baidu.com/"));
                break;
            }
            case 6: {
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "GET", "https://www.sogou.com/"));
                break;
            }
            default: {
                this.quited = true;
                ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "QUIT"));
            }
        }
    }

    private static RespMessage command(ByteBufAllocator alloc, String ... commands) {
        return DefaultArrayMessage.bulkStringArrayUtf8((ByteBufAllocator)alloc, (CharSequence[])commands);
    }
}

