/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.resp3;

import com.github.fmjsjx.libnetty.handler.ssl.SslContextProvider;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProviders;
import com.github.fmjsjx.libnetty.http.client.SimpleHttpClient;
import com.github.fmjsjx.libnetty.resp.CachedBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.CachedErrorMessage;
import com.github.fmjsjx.libnetty.resp.DefaultArrayMessage;
import com.github.fmjsjx.libnetty.resp.DefaultBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.DefaultErrorMessage;
import com.github.fmjsjx.libnetty.resp.RedisRequest;
import com.github.fmjsjx.libnetty.resp.RespBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.RespMessage;
import com.github.fmjsjx.libnetty.resp.RespMessages;
import com.github.fmjsjx.libnetty.resp.util.IgnoredCaseAsciiKeyMap;
import com.github.fmjsjx.libnetty.resp3.CachedBooleanMessage;
import com.github.fmjsjx.libnetty.resp3.DefaultDoubleMessage;
import com.github.fmjsjx.libnetty.resp3.DefaultMapMessage;
import com.github.fmjsjx.libnetty.resp3.DefaultSetMessage;
import com.github.fmjsjx.libnetty.resp3.FieldValuePair;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class TestServerHandler
extends SimpleChannelInboundHandler<RedisRequest> {
    private static final SslContextProvider INSECURE_FOR_CLIENT = SslContextProviders.insecureForClient();
    private static final ChannelFutureListener READ_NEXT = f -> f.channel().read();
    private static final CachedErrorMessage PROTO_ERROR = CachedErrorMessage.createAscii((CharSequence)"NOPROTO sorry this protocol version is not supported");
    private static final CachedBulkStringMessage SERVER_KEY = CachedBulkStringMessage.createAscii((CharSequence)"server");
    private static final CachedBulkStringMessage SERVER_VALUE = CachedBulkStringMessage.createAscii((CharSequence)"test");
    private static final CachedBulkStringMessage VERSION_KEY = CachedBulkStringMessage.createAscii((CharSequence)"version");
    private static final CachedBulkStringMessage VERSION_VALUE = CachedBulkStringMessage.createAscii((CharSequence)"1.0.0");
    private static final CachedBulkStringMessage PROTO_KEY = CachedBulkStringMessage.createAscii((CharSequence)"proto");
    private final IgnoredCaseAsciiKeyMap<BiConsumer<ChannelHandlerContext, RedisRequest>> commandProcedures;
    private boolean supportResp3;
    private final List<RespBulkStringMessage> smembers = Arrays.stream(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).mapToObj(CachedBulkStringMessage::create).collect(Collectors.toList());
    private final List<FieldValuePair<RespBulkStringMessage, RespBulkStringMessage>> hgetall = Arrays.asList(new FieldValuePair((RespMessage)CachedBulkStringMessage.createAscii((CharSequence)"name"), (RespMessage)CachedBulkStringMessage.createAscii((CharSequence)"test")), new FieldValuePair((RespMessage)CachedBulkStringMessage.createAscii((CharSequence)"value"), (RespMessage)CachedBulkStringMessage.createAscii((CharSequence)"Hello World!")));

    TestServerHandler() {
        this.commandProcedures = new IgnoredCaseAsciiKeyMap();
        this.commandProcedures.put("HELLO", this::hello);
        this.commandProcedures.put("GET", this::get);
        this.commandProcedures.put("HGETALL", this::hgetall);
        this.commandProcedures.put("ECHO", this::echo);
        this.commandProcedures.put("SMEMBERS", this::smembers);
        this.commandProcedures.put("PING", this::ping);
        this.commandProcedures.put("SELECT", this::justOk);
        this.commandProcedures.put("QUIT", this::quit);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " connected");
        ctx.read();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " disconnected");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, RedisRequest msg) throws Exception {
        System.out.println("-- message received --");
        System.out.println(msg);
        BiConsumer procedure = (BiConsumer)this.commandProcedures.get(msg.command().content());
        if (procedure == null) {
            String cmd = msg.command().toText();
            ctx.writeAndFlush((Object)DefaultErrorMessage.createErr((CharSequence)("unknown command `" + cmd + "`"))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            procedure.accept(ctx, msg);
        }
    }

    private void hello(ChannelHandlerContext ctx, RedisRequest msg) {
        if (msg.size() < 2) {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"echo")).addListener((GenericFutureListener)READ_NEXT);
        } else {
            try {
                int version = msg.argument(1).intValue();
                switch (version) {
                    case 2: {
                        DefaultArrayMessage array = new DefaultArrayMessage(new RespMessage[]{SERVER_KEY, SERVER_VALUE, VERSION_KEY, VERSION_VALUE, PROTO_KEY, RespMessages.integer((int)2)});
                        ctx.writeAndFlush((Object)array).addListener((GenericFutureListener)READ_NEXT);
                        break;
                    }
                    case 3: {
                        this.supportResp3 = true;
                        DefaultMapMessage map = new DefaultMapMessage();
                        map.put((RespMessage)SERVER_KEY, (RespMessage)SERVER_VALUE);
                        map.put((RespMessage)VERSION_KEY, (RespMessage)VERSION_VALUE);
                        map.put((RespMessage)PROTO_KEY, (RespMessage)RespMessages.integer((int)3));
                        map.put((RespMessage)DefaultBulkStringMessage.createAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)"testMode"), (RespMessage)CachedBooleanMessage.TRUE);
                        ZonedDateTime now = ZonedDateTime.now();
                        String unixTime = now.toEpochSecond() + "." + now.getNano() / 1000000;
                        map.put((RespMessage)DefaultBulkStringMessage.createAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)"unixTime"), (RespMessage)new DefaultDoubleMessage(unixTime));
                        ctx.writeAndFlush((Object)map).addListener((GenericFutureListener)READ_NEXT);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            catch (Exception e) {
                ctx.writeAndFlush((Object)PROTO_ERROR).addListener((GenericFutureListener)READ_NEXT);
            }
        }
    }

    private void echo(ChannelHandlerContext ctx, RedisRequest msg) {
        if (msg.size() != 2) {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"echo")).addListener((GenericFutureListener)READ_NEXT);
        } else {
            RespBulkStringMessage message = msg.argument(1);
            ctx.writeAndFlush((Object)message.retainedDuplicate()).addListener((GenericFutureListener)READ_NEXT);
        }
    }

    private void smembers(ChannelHandlerContext ctx, RedisRequest msg) {
        if (msg.size() != 2) {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"smembers")).addListener((GenericFutureListener)READ_NEXT);
        } else {
            try {
                int size = Math.max(0, Math.min(msg.argument(1).intValue(), 9));
                if (this.supportResp3) {
                    ctx.writeAndFlush((Object)new DefaultSetMessage(this.smembers.subList(0, size))).addListener((GenericFutureListener)READ_NEXT);
                } else {
                    ctx.writeAndFlush((Object)new DefaultArrayMessage(this.smembers.subList(0, size))).addListener((GenericFutureListener)READ_NEXT);
                }
            }
            catch (Exception e) {
                ctx.writeAndFlush((Object)RespMessages.emptyArray()).addListener((GenericFutureListener)READ_NEXT);
            }
        }
    }

    private void hgetall(ChannelHandlerContext ctx, RedisRequest msg) {
        if (msg.size() != 2) {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"smembers")).addListener((GenericFutureListener)READ_NEXT);
        } else if (this.supportResp3) {
            ctx.writeAndFlush((Object)new DefaultMapMessage(this.hgetall)).addListener((GenericFutureListener)READ_NEXT);
        } else {
            ArrayList<RespMessage> array = new ArrayList<RespMessage>();
            for (FieldValuePair<RespBulkStringMessage, RespBulkStringMessage> pair : this.hgetall) {
                array.add(pair.field());
                array.add(pair.value());
            }
            ctx.writeAndFlush((Object)new DefaultArrayMessage(array)).addListener((GenericFutureListener)READ_NEXT);
        }
    }

    private void ping(ChannelHandlerContext ctx, RedisRequest msg) {
        int size = msg.size();
        if (msg.size() == 1) {
            ctx.writeAndFlush((Object)RespMessages.pong()).addListener((GenericFutureListener)READ_NEXT);
        } else if (size == 2) {
            ctx.writeAndFlush((Object)msg.argument(1).retainedDuplicate()).addListener((GenericFutureListener)READ_NEXT);
        } else {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"ping")).addListener((GenericFutureListener)READ_NEXT);
        }
    }

    private void get(ChannelHandlerContext ctx, RedisRequest msg) {
        Channel channel = ctx.channel();
        String path = msg.argument(1).textValue(CharsetUtil.UTF_8);
        try (SimpleHttpClient client = ((SimpleHttpClient.Builder)SimpleHttpClient.builder().sslContextProvider(INSECURE_FOR_CLIENT)).build((EventLoopGroup)channel.eventLoop(), channel.getClass());){
            ((CompletableFuture)client.request(URI.create(path)).get().sendAsync(ByteBuf::retainedDuplicate).thenAccept(r -> {
                if (r.statusCode() >= 400) {
                    channel.writeAndFlush((Object)DefaultErrorMessage.createErr((CharSequence)r.status().toString())).addListener((GenericFutureListener)READ_NEXT);
                } else {
                    channel.writeAndFlush((Object)new DefaultBulkStringMessage((ByteBuf)r.content())).addListener((GenericFutureListener)READ_NEXT);
                }
            })).whenComplete((v, e) -> {
                if (e != null) {
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    channel.writeAndFlush((Object)DefaultErrorMessage.createErr((CharSequence)e.toString())).addListener((GenericFutureListener)READ_NEXT);
                }
            });
        }
    }

    private void justOk(ChannelHandlerContext ctx, RedisRequest msg) {
        ctx.writeAndFlush((Object)RespMessages.ok()).addListener((GenericFutureListener)READ_NEXT);
    }

    private void quit(ChannelHandlerContext ctx, RedisRequest msg) {
        ctx.writeAndFlush((Object)RespMessages.ok()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

