/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.resp;

import com.github.fmjsjx.libnetty.resp.DefaultArrayMessage;
import com.github.fmjsjx.libnetty.resp.RespBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.RespMessage;
import com.github.fmjsjx.libnetty.resp.RespMessages;
import com.github.fmjsjx.libnetty.resp.RespSimpleStringMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;

class TestClientHandler
extends SimpleChannelInboundHandler<RespMessage> {
    private boolean first = true;

    TestClientHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, RespMessage msg) throws Exception {
        System.out.println("-- RESP message received --");
        System.out.println(msg);
        if (msg instanceof RespBulkStringMessage) {
            System.out.println(((RespBulkStringMessage)msg).textValue(CharsetUtil.UTF_8));
            if (this.first) {
                DefaultArrayMessage cmd = DefaultArrayMessage.bulkStringArrayUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence[])new CharSequence[]{"GET", "https://www.baidu.com/"});
                ctx.writeAndFlush((Object)cmd);
                this.first = false;
            } else {
                ctx.writeAndFlush((Object)DefaultArrayMessage.bulkStringArrayAscii((ByteBufAllocator)ctx.alloc(), (CharSequence[])new CharSequence[]{"QUIT"}));
            }
        } else if (msg instanceof RespSimpleStringMessage && RespMessages.ok().value().equals(((RespSimpleStringMessage)msg).value())) {
            System.out.println("is OK");
            ctx.close();
        }
    }
}

