/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.tasks;

import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginMode;
import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginParametersProvider;
import com.github.fgiannesini.libsass.gradle.plugin.tasks.CompileLibSassTaskDelegate;
import io.bit3.jsass.CompilationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class CompileLibSassWatcher {
    private final Logger logger;
    private final CompileLibSassTaskDelegate compileLibSassTaskDelegate;
    private final Path watchedDirectory;
    private final PluginMode pluginMode;

    public CompileLibSassWatcher(Logger logger, Project project) {
        this.logger = logger;
        this.pluginMode = PluginMode.DEVELOPPEMENT;
        this.compileLibSassTaskDelegate = new CompileLibSassTaskDelegate(project, this.logger, this.pluginMode);
        this.watchedDirectory = this.getWatchedDirectory(project);
    }

    public void launchWatcher() {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            this.registerFolderAndSubFolders(watcher, this.watchedDirectory);
            while (true) {
                WatchKey key;
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ex) {
                    this.logger.error("Wath Service interrupted", (Throwable)ex);
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path dir = (Path)key.watchable();
                    Path modifiedFile = dir.resolve((Path)ev.context());
                    this.logger.info(kind.name() + ": " + modifiedFile);
                    this.logger.info(modifiedFile.toFile().getAbsolutePath());
                    if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) && modifiedFile.toFile().isDirectory()) {
                        this.registerFolderAndSubFolders(watcher, modifiedFile);
                    }
                    try {
                        this.compileLibSassTaskDelegate.compile();
                    }
                    catch (CompilationException ce) {
                        this.logger.error("Error during compilation, see above for details");
                    }
                }
                key.reset();
            }
        }
        catch (IOException ex) {
            this.logger.error("Problem on Watch Service", (Throwable)ex);
            return;
        }
    }

    private void registerFolderAndSubFolders(WatchService watcher, Path directory) throws IOException {
        directory.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.logger.info("Watch Service registered for dir: " + directory.getFileName());
        File[] listFiles = directory.toFile().listFiles();
        if (listFiles != null) {
            for (File subFile : listFiles) {
                if (!subFile.isDirectory()) continue;
                this.registerFolderAndSubFolders(watcher, subFile.toPath());
            }
        }
    }

    private Path getWatchedDirectory(Project project) {
        PluginParametersProvider parametersProvider = new PluginParametersProvider(project, this.pluginMode);
        Path watchedDirectory = parametersProvider.getLibsassWatchDirectory();
        if (watchedDirectory == null) {
            throw new IllegalArgumentException("watchedDirectoryPath must be set");
        }
        File file = watchedDirectory.toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException(watchedDirectory.toAbsolutePath().toString() + " doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(watchedDirectory.toAbsolutePath().toString() + " should be a folder");
        }
        return watchedDirectory;
    }
}

