/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.installer;

import com.github.fgiannesini.libsass.gradle.plugin.installer.ScssFrameworkInstaller;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class CompassInstaller
extends ScssFrameworkInstaller {
    public CompassInstaller(Project project, Logger logger) {
        super(logger);
    }

    @Override
    protected void copySourcesToInstallationPath(File sourcesFolder, Path installationPath) throws IOException {
        this.correctFilesImports(sourcesFolder, 0);
        super.copySourcesToInstallationPath(sourcesFolder, installationPath);
    }

    protected void correctFilesImports(File sourcesFolder, int level) throws IOException {
        File[] listFiles = sourcesFolder.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                this.correctFilesImports(file, level + 1);
                continue;
            }
            if (!file.getName().endsWith(".scss")) continue;
            this.correctFileImport(level, file);
        }
    }

    private void correctFileImport(int level, File file) throws IOException {
        this.logger.info("Correcting compass file " + file.getName());
        String fileContent = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        fileContent = this.correctImport(level, fileContent);
        fileContent = this.correctRubyFunctionCall(fileContent);
        FileUtils.writeStringToFile((File)file, (String)fileContent, (Charset)Charset.defaultCharset());
    }

    private String correctRubyFunctionCall(String line) {
        String stringToReplace = "prefix-usage";
        if (line.contains("prefix-usage")) {
            line = line.replace("prefix-usage", "0;//prefix-usage");
        }
        return line;
    }

    private String correctImport(int level, String fileContent) {
        String originFolderPath = "\"" + StringUtils.repeat((String)"../", (int)level) + "compass/";
        fileContent = fileContent.replaceAll("\"compass/", originFolderPath);
        return fileContent;
    }
}

