/*
 * Decompiled with CFR 0.152.
 */
package com.github.fgiannesini.libsass.gradle.plugin.compiler;

import com.github.fgiannesini.libsass.gradle.plugin.compiler.PluginInputSyntax;
import com.github.fgiannesini.libsass.gradle.plugin.extension.PluginParametersProvider;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.logging.Logger;

public class LibSassCompiler {
    private Options options;
    private final Logger logger;
    private final PluginParametersProvider parametersProvider;

    public LibSassCompiler(Logger logger, PluginParametersProvider parametersProvider) {
        this.logger = logger;
        this.parametersProvider = parametersProvider;
        this.init();
    }

    private void init() {
        this.options = new Options();
        this.options.setOutputStyle(OutputStyle.values()[this.parametersProvider.getOutputStyle().ordinal()]);
        Stream<File> files = Arrays.stream(this.parametersProvider.getIncludePaths()).map(File::new);
        if (this.logger.isInfoEnabled()) {
            files = files.peek(file -> this.logger.info(file.getPath()));
        }
        files.forEach(this.options.getIncludePaths()::add);
        this.options.setSourceComments(this.parametersProvider.getSourceComments().booleanValue());
        this.options.setOmitSourceMapUrl(this.parametersProvider.getOmitSourceMappingUrl());
        this.options.setSourceMapEmbed(this.parametersProvider.getSourceMapEmbed().booleanValue());
        this.options.setSourceMapContents(this.parametersProvider.getSourceMapContents().booleanValue());
        this.options.setIsIndentedSyntaxSrc(PluginInputSyntax.SASS.equals((Object)this.parametersProvider.getInputSyntax()));
        this.options.setPrecision(this.parametersProvider.getPrecision());
        this.options.setSourceMapFile(this.parametersProvider.getSourceMapUri());
    }

    public void compileFile() throws CompilationException {
        Output output = this.launchCompilation();
        this.writeCss(output);
        this.generateSourceMap(output);
    }

    protected void writeCss(Output output) {
        try {
            File outputFile = new File(this.parametersProvider.getOutputUri());
            this.logger.info("Write CSS file " + outputFile.getPath());
            FileUtils.forceMkdir((File)outputFile.getParentFile());
            FileUtils.write((File)outputFile, (CharSequence)output.getCss(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.error("Error writing CSS file", (Throwable)e);
        }
    }

    protected void generateSourceMap(Output output) {
        String sourceMap = output.getSourceMap();
        if (StringUtils.isBlank((CharSequence)sourceMap)) {
            this.logger.info("No sourcemap file to generate");
            return;
        }
        try {
            File sourceMapFile = new File(this.options.getSourceMapFile());
            this.logger.info("Write source map file " + sourceMapFile.getPath());
            FileUtils.forceMkdir((File)sourceMapFile.getParentFile());
            FileUtils.write((File)sourceMapFile, (CharSequence)sourceMap, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.error("Error writing source map file", (Throwable)e);
        }
    }

    protected Output launchCompilation() throws CompilationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Launching compilation");
        }
        Compiler compiler = new Compiler();
        try {
            Output output = compiler.compileFile(this.parametersProvider.getInputUri(), this.parametersProvider.getOutputUri(), this.options);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("End of compilation");
            }
            return output;
        }
        catch (CompilationException compilationException) {
            this.logger.error(compilationException.getErrorFile());
            this.logger.error(compilationException.getErrorJson());
            this.logger.error(compilationException.getErrorMessage());
            this.logger.error(compilationException.getErrorSrc());
            this.logger.error(compilationException.getErrorText());
            throw compilationException;
        }
    }
}

